/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.modules.ModulesDataContainer;
import org.jamocha.engine.workingmemory.elements.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDataContainer
extends ModulesDataContainer {
    private final Map<String, Set<Template>> moduleToTemplates;

    public TemplateDataContainer() {
        this.idToCLIPSElement = new HashMap();
        this.moduleToTemplates = new HashMap<String, Set<Template>>();
    }

    @Override
    protected void handleClear() {
        Set<String> keys = this.moduleToTemplates.keySet();
        for (String key : keys) {
            this.moduleToTemplates.remove(key);
        }
    }

    public Template get(String templateName, Module module) {
        return (Template)this.idToCLIPSElement.get(this.toKeyString(templateName, module.getName()));
    }

    public boolean add(Template template, Module module) {
        String templateKey = this.toKeyString(template.getName(), module.getName());
        if (this.idToCLIPSElement.containsKey(templateKey)) {
            return false;
        }
        this.idToCLIPSElement.put(templateKey, template);
        Set<Template> moduleSet = this.moduleToTemplates.get(module.getName());
        if (moduleSet == null) {
            moduleSet = new HashSet<Template>();
            this.moduleToTemplates.put(module.getName(), moduleSet);
        }
        moduleSet.add(template);
        return true;
    }

    public Template remove(String templateName, Module module) {
        Template result = (Template)this.idToCLIPSElement.remove(this.toKeyString(templateName, module.getName()));
        Set<Template> moduleSet = this.moduleToTemplates.get(module.getName());
        moduleSet.remove(result);
        return result;
    }

    private String toKeyString(String templateName, String moduleName) {
        return moduleName + "::" + templateName;
    }

    public boolean containsTemplate(Module defmodule, Template template) {
        return this.idToCLIPSElement.containsKey(this.toKeyString(template.getName(), defmodule.getName()));
    }

    public List<Template> getTemplates(Module defmodule) {
        ArrayList<Template> templates = new ArrayList<Template>();
        Set<Template> templs = this.moduleToTemplates.get(defmodule.getName());
        if (templs != null) {
            for (Template templ : templs) {
                templates.add(templ);
            }
        }
        return templates;
    }
}

