/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.modules.ModulesDataContainer;
import org.jamocha.rules.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleDataContainer
extends ModulesDataContainer {
    private final Map<String, Set<Rule>> moduleToRules;

    public RuleDataContainer() {
        this.idToCLIPSElement = new HashMap();
        this.moduleToRules = new HashMap<String, Set<Rule>>();
    }

    @Override
    protected void handleClear() {
        Set<String> keys = this.moduleToRules.keySet();
        for (String key : keys) {
            this.moduleToRules.remove(key);
        }
    }

    public Rule get(String ruleName, Module module) {
        return (Rule)this.idToCLIPSElement.get(this.toKeyString(ruleName, module.getName()));
    }

    public boolean add(Rule rule, Module module) {
        String ruleKey = this.toKeyString(rule.getName(), module.getName());
        if (this.idToCLIPSElement.containsKey(ruleKey)) {
            return false;
        }
        this.idToCLIPSElement.put(ruleKey, rule);
        Set<Rule> moduleSet = this.moduleToRules.get(module.getName());
        if (moduleSet == null) {
            moduleSet = new HashSet<Rule>();
            this.moduleToRules.put(module.getName(), moduleSet);
        }
        moduleSet.add(rule);
        return true;
    }

    public Rule remove(String ruleName, Module module) {
        Rule result = (Rule)this.idToCLIPSElement.remove(this.toKeyString(ruleName, module.getName()));
        Set<Rule> moduleSet = this.moduleToRules.get(module.getName());
        moduleSet.remove(result);
        return result;
    }

    public boolean containsRule(Rule rule, Module module) {
        return this.idToCLIPSElement.containsKey(this.toKeyString(rule.getName(), module.getName()));
    }

    private String toKeyString(String ruleName, String moduleName) {
        return moduleName + "::" + ruleName;
    }

    public List<Rule> getRules(Module module) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Set<Rule> templs = this.moduleToRules.get(module.getName());
        if (templs != null) {
            for (Rule rule : templs) {
                rules.add(rule);
            }
        }
        return rules;
    }

    public List<Rule> getRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Object key : this.idToCLIPSElement.keySet()) {
            Rule rule = (Rule)this.idToCLIPSElement.get(key);
            rules.add(rule);
        }
        return rules;
    }
}

