/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.strings;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class StringCat
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "str-cat";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        StringBuilder txt = new StringBuilder();
        if (params != null) {
            for (Parameter param : params) {
                JamochaValue value = param.getValue(engine);
                if (value.getType().equals((Object)JamochaType.IDENTIFIER) && value.getIdentifierValue().equals("crlf")) {
                    txt.append("\n");
                    continue;
                }
                if (value.getType().equals((Object)JamochaType.STRING)) {
                    txt.append(value.getStringValue());
                    continue;
                }
                txt.append(value.toString());
            }
        } else {
            throw new IllegalParameterException(1, true);
        }
        return JamochaValue.newString(txt.toString());
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Concatenates two or more strings into one string and returns the new string.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "String to be concatenated with the strings from the other arguments.";
        }

        public String getParameterName(int parameter) {
            return "string";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.STRINGS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(str-cat \"Jamocha \" \"rulez\" \"!!!\")";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "Jamocha rulez!!!";
        }
    }
}

