/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Watch
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    protected static final String NAME = "watch";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            for (int idx = 0; idx < params.length; ++idx) {
                String cmd = params[idx].getValue(engine).getIdentifierValue();
                this.setWatch(engine, cmd);
            }
        }
        return JamochaValue.NIL;
    }

    protected boolean setWatch(Engine engine, String cmd) {
        boolean result = true;
        if (cmd.equals("all")) {
            engine.setWatch(2);
        } else if (cmd.equals("facts")) {
            engine.setWatch(3);
        } else if (cmd.equals("activations")) {
            engine.setWatch(1);
        } else if (cmd.equals("rules")) {
            engine.setWatch(4);
        } else {
            result = false;
        }
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Allows users to watch different engine processes, likes activations, facts and rules.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "What to watch. One or several of: all, facts, activations, rules or none.Value is not stored. If you want to do so use (set) function or GUI settings instead.";
        }

        public String getParameterName(int parameter) {
            return Watch.NAME;
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(watch facts)\n(deftemplate templ2 (slot name))\n(assert (templ2 (name test1)) (templ2 (name test2)))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

