/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class UnWatch
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    protected static final String NAME = "unwatch";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            for (int idx = 0; idx < params.length; ++idx) {
                String cmd = params[idx].getValue(engine).getIdentifierValue();
                this.setUnWatch(engine, cmd);
            }
        }
        return JamochaValue.NIL;
    }

    protected void setUnWatch(Engine engine, String cmd) {
        if (cmd.equals("all")) {
            engine.setUnWatch(2);
        } else if (cmd.equals("facts")) {
            engine.setUnWatch(3);
        } else if (cmd.equals("activations")) {
            engine.setUnWatch(1);
        } else if (cmd.equals("rules")) {
            engine.setUnWatch(4);
        }
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Allows users to remove the watch of different engine processes, like activations, facts and rules.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "What to unwatch. One or several of: all, facts, activations or rules.";
        }

        public String getParameterName(int parameter) {
            return UnWatch.NAME;
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(watch facts)\n(deftemplate templ2 (slot name))\n(assert (templ2 (name test1)) (templ2 (name test2)))\n(unwatch facts)\n(assert (templ2 (name test3)))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

