/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.rules.Defrule;

public class UnDefrule
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "undefrule";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        if (params.length == 1) {
            String rl = params[0].getValue(engine).getStringValue();
            Logging.logger(this.getClass()).debug("undefining rule " + rl);
            Defrule defrl = (Defrule)engine.getCurrentFocus().findRule(rl);
            if (defrl != null) {
                engine.getCurrentFocus().removeRule(defrl);
                result = JamochaValue.TRUE;
            }
        }
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Removes a rule in the engine. Returns true on success.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Rule that will be removed.";
        }

        public String getParameterName(int parameter) {
            return "ruleName";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate customer\n  (slot first)\n  (slot last)\n  (slot title)\n  (slot address)\n)\n(defrule rule\n  (customer\n    (first \"john\")\n  )\n=>\n  (printout t \"rule was fired\" )\n)\n(assert (customer (first \"john\")(last \"doe\")(address \"moon\") ) )\n(fire)\n(rules)\n(undefrule rule)\n(rules)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

