/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.settings.JamochaSettings;

public class SetSettings
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "set-settings";

    public SetSettings() {
        this.aliases.add("set");
    }

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaSettings prefs = JamochaSettings.getInstance();
        if (params != null && params.length == 2) {
            String value;
            String property = params[0].getValue(engine).getStringValue();
            boolean result = prefs.set(property, value = params[1].getValue(engine).implicitCast(JamochaType.STRING).toString());
            return result ? JamochaValue.TRUE : JamochaValue.FALSE;
        }
        if (params != null && params.length == 0) {
            engine.writeMessage(prefs.getSettingsTable());
            return JamochaValue.TRUE;
        }
        return JamochaValue.FALSE;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Jamocha settings can be set by this function.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            if (parameter == 0) {
                return "Name of property to be set";
            }
            return "Property value";
        }

        public String getParameterName(int parameter) {
            if (parameter == 0) {
                return "property name";
            }
            return "property value";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.STRINGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(set watch-activations true)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

