/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.settings.JamochaSettings;

public class SetDefault
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "set-default";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaSettings prefs = JamochaSettings.getInstance();
        if (params != null && params.length == 1) {
            String property = params[0].getValue(engine).getStringValue();
            boolean result = prefs.toDefault(property);
            return result ? JamochaValue.TRUE : JamochaValue.FALSE;
        }
        return JamochaValue.FALSE;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "A given Jamocha setting will be set to its default value.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Name of property to be reset";
        }

        public String getParameterName(int parameter) {
            return "property name";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.STRINGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(set-default watch-activations)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

