/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.Constants;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.util.ProfileStats;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class PrintProfile
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "print-profile";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        engine.writeMessage("fire ET=" + ProfileStats.fireTime + " ms" + Constants.LINEBREAK, "t");
        engine.writeMessage("assert ET=" + ProfileStats.assertTime + " ms" + Constants.LINEBREAK, "t");
        engine.writeMessage("retract ET=" + ProfileStats.retractTime + " ms" + Constants.LINEBREAK, "t");
        engine.writeMessage("add Activation ET=" + ProfileStats.addActivation + " ms" + Constants.LINEBREAK, "t");
        engine.writeMessage("remove Activation ET=" + ProfileStats.rmActivation + " ms" + Constants.LINEBREAK, "t");
        engine.writeMessage("Activation added=" + ProfileStats.addcount + Constants.LINEBREAK, "t");
        engine.writeMessage("Activation removed=" + ProfileStats.rmcount + Constants.LINEBREAK, "t");
        return JamochaValue.NIL;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Prints out the current profile information.";
        }

        public int getParameterCount() {
            return 0;
        }

        public String getParameterDescription(int parameter) {
            return "";
        }

        public String getParameterName(int parameter) {
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(print-profile)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

