/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class NodeMemory
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "node-memory";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        Node n = null;
        long nodeId = params[0].getValue(engine).getLongValue();
        for (Node m : engine.getNet().getAllNodes()) {
            if ((long)m.getId() != nodeId) continue;
            n = m;
        }
        if (n == null) {
            return JamochaValue.FALSE;
        }
        engine.writeMessage("Memory from node " + nodeId + ":\n");
        for (WorkingMemoryElement wme : n.memory()) {
            engine.writeMessage(((Object)wme).toString());
        }
        return JamochaValue.TRUE;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Prints the memory content of a node. Returns 'True', iff there was a node with the given id.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            if (parameter == 0) {
                return "The node ID";
            }
            return null;
        }

        public String getParameterName(int parameter) {
            if (parameter == 0) {
                return "node-id";
            }
            return null;
        }

        public JamochaType[] getParameterTypes(int parameter) {
            if (parameter == 0) {
                return JamochaType.LONGS;
            }
            return null;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(node-memory 0)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

