/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.Constants;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class MemoryUsed
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "mem-used";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long used = total - free;
        used = used / 1024L / 1024L;
        long mbtotal = (total /= 1024L) / 1024L;
        engine.writeMessage(String.valueOf(used) + "Mb used of " + String.valueOf(mbtotal) + "Mb " + String.valueOf(total) + "Kb " + Constants.LINEBREAK, "t");
        return JamochaValue.NIL;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Prints out the memory space currently in  use. Returns NIL.";
        }

        public int getParameterCount() {
            return 0;
        }

        public String getParameterDescription(int parameter) {
            return "";
        }

        public String getParameterName(int parameter) {
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(mem-used)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

