/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import java.io.File;
import org.jamocha.Constants;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class ListDirectory
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "list-dir";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            File dir = new File(params[0].getValue(engine).getStringValue());
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                for (int idx = 0; idx < files.length; ++idx) {
                    if (files[idx].isDirectory()) {
                        engine.writeMessage("d " + files[idx] + Constants.LINEBREAK);
                        continue;
                    }
                    engine.writeMessage("- " + files[idx] + Constants.LINEBREAK);
                }
                engine.writeMessage(files.length + " files in the directory" + Constants.LINEBREAK);
            } else {
                engine.writeMessage(dir.getPath() + " is not a directory.");
            }
        }
        return JamochaValue.NIL;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Prints out the files and folders of a given directory. It is the same command asdir in DOS and ls in Unix. The return value is NIL.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Directory to list files and folders of.";
        }

        public String getParameterName(int parameter) {
            return "dir";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(list-dir examples)\n(list-dir /var/tmp)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

