/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.AssertException;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.AssertConfiguration;
import org.jamocha.engine.configurations.SlotConfiguration;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Deffact;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class FindFactByFact
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new FindFactByFactDescription();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "find-fact-by-fact";
    protected Fact[] triggerFacts = null;

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public void setTriggerFacts(Fact[] facts) {
        this.triggerFacts = facts;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        if (params.length == 1) {
            Deffact fact = null;
            if (params[0] instanceof AssertConfiguration) {
                Fact existingFact;
                AssertConfiguration ac = null;
                String templateName = null;
                SlotConfiguration[] scArray = null;
                ac = (AssertConfiguration)params[0];
                templateName = ac.getTemplateName();
                Deftemplate template = (Deftemplate)engine.getCurrentFocus().getTemplate(templateName);
                if (template == null) {
                    throw new AssertException("Template " + template.getName() + "could not be found");
                }
                scArray = ac.getSlotConfigurations();
                fact = (Deffact)template.createFact(scArray, engine);
                if (fact.hasBinding()) {
                    fact.resolveValues(engine, this.triggerFacts);
                    fact = fact.cloneFact(engine);
                }
                result = (existingFact = engine.getModules().getFactByFact(fact)) == null ? JamochaValue.NIL : JamochaValue.newFactId(existingFact.getFactId());
            }
        }
        return result;
    }

    private static final class FindFactByFactDescription
    implements FunctionDescription {
        private FindFactByFactDescription() {
        }

        public String getDescription() {
            return "Returns the ID of the given fact or NIL if it wasn't found.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Fact to search for.";
        }

        public String getParameterName(int parameter) {
            return "fact";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.FACTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.FACTS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate car (slot color)(slot speed))\n(assert (car (color \"red\")(speed 200)))\n(assert (car (color \"blue\")(speed 150)))\n(assert (car (color \"green\")(speed 100)))\n(find-fact-by-fact (car (color \"green\") (speed 100)))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "f-4";
        }
    }
}

