/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import java.util.List;
import org.jamocha.Constants;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.util.FactUtils;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Facts
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "facts";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        List<Fact> facts = engine.getModules().getAllFacts();
        Fact[] sorted = FactUtils.sortFacts(facts);
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < sorted.length; ++idx) {
            Fact ft = sorted[idx];
            sb.append(ft.toString()).append(Constants.LINEBREAK);
        }
        sb.append("for a total of ").append(sorted.length);
        return JamochaValue.newString(sb.toString());
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Prints out all the facts which are currently asserted to the rule engine.";
        }

        public int getParameterCount() {
            return 0;
        }

        public String getParameterDescription(int parameter) {
            return "";
        }

        public String getParameterName(int parameter) {
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(facts)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

