/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.DefmoduleConfiguration;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Defmodule
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "defmodule";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        if (params == null || params.length != 1) {
            throw new IllegalParameterException(1);
        }
        DefmoduleConfiguration defmodconf = (DefmoduleConfiguration)params[0];
        engine.addModule(defmodconf.getModuleName());
        result = JamochaValue.TRUE;
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Defines a new module in the engine.\nDefmodule enables the division of rules and facts into distinct groups called modules. Modules help to physically organize large numbers of rules into logical groups. Furthermore modules provide a control mechanism: The rules in a module fire only when that module has the focus, and only one module can be in focus at a time.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Name for the new module";
        }

        public String getParameterName(int parameter) {
            return "name";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(defmodule PIZZAENV)\n(get-current-module)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

