/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Clear
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "clear";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null) {
            if (params.length == 1) {
                JamochaValue param = params[0].getValue(engine);
                if (param.getType().equals((Object)JamochaType.IDENTIFIER)) {
                    String identifier = param.getIdentifierValue();
                    if (identifier.equals("deffacts") || identifier.equals("facts")) {
                        engine.clearFacts();
                    } else if (identifier.equals("defrules") || identifier.equals("rules")) {
                        engine.clearRules();
                    } else {
                        throw new EvaluationException("Unknown argument " + param.getIdentifierValue());
                    }
                    return JamochaValue.TRUE;
                }
                throw new IllegalTypeException(JamochaType.IDENTIFIERS, param.getType());
            }
            if (params.length == 0) {
                engine.clearAll();
                return JamochaValue.TRUE;
            }
        }
        throw new IllegalParameterException(0);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Clears the Rete engine. Removes all constructs and all associated data structures (such as facts and objects) from the Rete environment.\nIn case of a given argument it is parsed as identifier and only the constructs that are identified by it are removed.\nReturns true on success.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            if (parameter > 0) {
                return "";
            }
            return "Optional identifier saying what to clear (\"deffacts\" or \"objects\"), if not specified: all is cleared.";
        }

        public String getParameterName(int parameter) {
            if (parameter > 0) {
                return "";
            }
            return "what";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            if (parameter > 0) {
                return JamochaType.NONE;
            }
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return true;
        }

        public String getExample() {
            return "(clear)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

