/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.math;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Subtract
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "subtract";

    public Subtract() {
        this.aliases.add("-");
    }

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            boolean isDouble = false;
            for (int idx = 0; idx < params.length; ++idx) {
                if (!params[idx].getValue(engine).getType().equals((Object)JamochaType.DOUBLE)) continue;
                isDouble = true;
                break;
            }
            if (isDouble) {
                double result = params[0].getValue(engine).implicitCast(JamochaType.DOUBLE).getDoubleValue();
                for (int i = 1; i < params.length; ++i) {
                    result -= params[i].getValue(engine).implicitCast(JamochaType.DOUBLE).getDoubleValue();
                }
                return JamochaValue.newDouble(result);
            }
            long result = params[0].getValue(engine).implicitCast(JamochaType.LONG).getLongValue();
            for (int i = 1; i < params.length; ++i) {
                result -= params[i].getValue(engine).implicitCast(JamochaType.LONG).getLongValue();
            }
            return JamochaValue.newLong(result);
        }
        throw new IllegalParameterException(1, true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the value of the first numeric argument minus the sum of all subsequent numeric arguments. This function can be called with the identifier 'subtract' or '-'";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            if (parameter == 0) {
                return "Numeric value from which to subtract all subsequent arguments.";
            }
            return "Numeric value(s) to subtract from the first argument.";
        }

        public String getParameterName(int parameter) {
            return "number";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NUMBERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NUMBERS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(subtract 15 4 3 -6)\n(- 15 4 3 -6)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return 14;
        }
    }
}

