/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.math;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class DegreesToRadians
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "deg-rad";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 1) {
            JamochaValue value = params[0].getValue(engine);
            if (!value.getType().equals((Object)JamochaType.DOUBLE) && !value.getType().equals((Object)JamochaType.LONG)) {
                value = value.implicitCast(JamochaType.DOUBLE);
            }
            if (value.getType().equals((Object)JamochaType.DOUBLE)) {
                return JamochaValue.newDouble(Math.toRadians(value.getDoubleValue()));
            }
            if (value.getType().equals((Object)JamochaType.LONG)) {
                return JamochaValue.newDouble(Math.toRadians(value.getLongValue()));
            }
        }
        throw new IllegalParameterException(1);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Converts an angle measured in degrees to an approximately equivalent angle measured in radians.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Angle, in degrees.";
        }

        public String getParameterName(int parameter) {
            return "angle";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NUMBERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.DOUBLES;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deg-rad 180)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return Math.toRadians(180.0);
        }
    }
}

