/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.math;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Abs
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "abs";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.NIL;
        if (params != null && params.length == 1) {
            JamochaValue value = params[0].getValue(engine);
            if (!value.getType().equals((Object)JamochaType.DOUBLE) && !value.getType().equals((Object)JamochaType.LONG)) {
                value = value.implicitCast(JamochaType.DOUBLE);
            }
            if (value.getType().equals((Object)JamochaType.DOUBLE)) {
                result = JamochaValue.newDouble(Math.abs(value.getDoubleValue()));
            } else if (value.getType().equals((Object)JamochaType.LONG)) {
                result = JamochaValue.newLong(Math.abs(value.getLongValue()));
            }
            return result;
        }
        throw new IllegalParameterException(1);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the absolute value of its numeric argument. The return type depends on the type of the argument.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Numeric value to get the absolute value from.";
        }

        public String getParameterName(int parameter) {
            return "number";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NUMBERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NUMBERS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(abs -57.39)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return 57.39;
        }
    }
}

