/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import java.util.LinkedList;
import java.util.List;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceMember$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "replace-member$";

    @Override
    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 2) {
            JamochaValue subject = params[0].getValue(engine);
            JamochaValue replacement = params[1].getValue(engine);
            if (subject.is(JamochaType.LIST)) {
                LinkedList<JamochaValue> tmpList = new LinkedList<JamochaValue>();
                LinkedList<JamochaValue> searchValues = new LinkedList<JamochaValue>();
                for (int i = 2; i < params.length; ++i) {
                    searchValues.add(params[i].getValue(engine));
                }
                int startIndex = 0;
                int end = subject.getListCount();
                while (startIndex < end) {
                    boolean found = false;
                    JamochaValue current = subject.getListValue(startIndex);
                    block2: for (JamochaValue searchValue : searchValues) {
                        if (searchValue.is(JamochaType.LIST)) {
                            if (searchValue.getListCount() > end - startIndex) continue;
                            for (int i = 0; i < searchValue.getListCount(); ++i) {
                                if (!subject.getListValue(startIndex + i).equals(searchValue.getListValue(i))) continue block2;
                            }
                            this.addReplacement(replacement, tmpList);
                            startIndex += searchValue.getListCount();
                            found = true;
                            break;
                        }
                        if (!current.equals(searchValue)) continue;
                        found = true;
                        this.addReplacement(replacement, tmpList);
                        ++startIndex;
                        break;
                    }
                    if (found) continue;
                    tmpList.add(current);
                    ++startIndex;
                }
                JamochaValue[] res = new JamochaValue[tmpList.size()];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = (JamochaValue)tmpList.get(i);
                }
                return JamochaValue.newList(res);
            }
            throw new IllegalTypeException(JamochaType.LISTS, subject.getType());
        }
        throw new IllegalParameterException(3, true);
    }

    private void addReplacement(JamochaValue replacement, List<JamochaValue> tmpList) {
        if (replacement.is(JamochaType.LIST)) {
            for (int i = 0; i < replacement.getListCount(); ++i) {
                tmpList.add(replacement.getListValue(i));
            }
        } else {
            tmpList.add(replacement);
        }
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Replaces specific items in a list with a given replacement. Arguments can either be single items or lists of items.\nIf a list is given to be replaced, the items are only replaced if they appear in identical (correct and coherent) order in the first list.\nThe function walks through the first list and tries to match each position to any of the arguments that are to be replaced. If it finds a match it replaces the item(s) at the current position. Afterwards it moves on to the next position after the replacement and tries to match this position anew to any of the arguments that are to replaced.\nTherefore the arguments are not necessarily processed in the order they are given, but replacements will not be matched recursively.\nReturns a new list consisting of untouched and replaced items.";
        }

        public int getParameterCount() {
            return 3;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "List to replace items in.";
                }
                case 1: {
                    return "Replacement for the searchValue in the list.";
                }
                case 2: {
                    return "Value to search for and replace in the list.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "someList";
                }
                case 1: {
                    return "replacement";
                }
                case 2: {
                    return "searchValue";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.LISTS;
                }
                case 1: {
                    return JamochaType.ANY;
                }
                case 2: {
                    return JamochaType.ANY;
                }
            }
            return JamochaType.ANY;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LISTS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 2;
        }

        public String getExample() {
            return "(replace-member$ (create$ a b a b) (create$ a b a) a b)\n(replace-member$ (create$ a b a b) (create$ a b a) (create$ a b))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "[a, b, a, a, b, a]";
        }
    }
}

