/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Member$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "member$";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 2) {
            JamochaValue result = JamochaValue.newLong(-1L);
            JamochaValue first = params[0].getValue(engine);
            JamochaValue second = params[1].getValue(engine);
            if (!second.getType().equals((Object)JamochaType.LIST)) {
                throw new IllegalTypeException(JamochaType.LISTS, second.getType());
            }
            if (first.is(JamochaType.LIST)) {
                if (second.getListCount() >= first.getListCount()) {
                    block0: for (int i = 0; i < second.getListCount() && second.getListCount() - i >= first.getListCount(); ++i) {
                        for (int j = 0; j < first.getListCount(); ++j) {
                            if (!first.getListValue(j).equals(second.getListValue(i + j))) continue block0;
                        }
                        result = JamochaValue.newLong(i + 1);
                    }
                }
            } else {
                if (first.is(JamochaType.FACT)) {
                    first = JamochaValue.newFactId(first.getFactValue().getFactId());
                }
                for (int i = 0; i < second.getListCount(); ++i) {
                    if (!first.equals(second.getListValue(i))) continue;
                    result = JamochaValue.newLong(i + 1);
                    break;
                }
            }
            return result;
        }
        throw new IllegalParameterException(2, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Compares if the first argument is a member of the list given in the second argument. If the the first argument is a list it is compared if there exists a subset of the second argument which is in the same order.\nReturns the position index of the element or the starting index of the subset in the second argument, if the first argument is a member.\nOtherwise returns -1.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Value to search for in the list.";
                }
                case 1: {
                    return "List to search in.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "value";
                }
                case 1: {
                    return "list";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.ANY;
                }
                case 1: {
                    return JamochaType.LISTS;
                }
            }
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LONGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(member$ 5 (create$ 1 2 3 4 5 6))\n(member$ (create$ 3 4) (create$ 1 2 3 4 5 6))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "3";
        }
    }
}

