/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Length$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "length$";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 1) {
            JamochaValue list = params[0].getValue(engine);
            if (list.is(JamochaType.NIL)) {
                return JamochaValue.newLong(0L);
            }
            if (list.is(JamochaType.LIST)) {
                return JamochaValue.newLong(list.getListCount());
            }
            throw new IllegalTypeException(JamochaType.LISTS, list.getType());
        }
        throw new IllegalParameterException(1, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the number of items of a list.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "List to get the length from.";
        }

        public String getParameterName(int parameter) {
            return "list";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.LISTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LONGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(length$ (create$ cheese milk eggs bread))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return 4;
        }
    }
}

