/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import java.util.LinkedList;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Insert$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "insert$";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 2) {
            JamochaValue list = params[0].getValue(engine);
            if (list == null) {
                list = JamochaValue.newList(new JamochaValue[0]);
            }
            int index = (int)params[1].getValue(engine).getLongValue();
            if (list.is(JamochaType.LIST)) {
                int i;
                if (index < 1 && list.getListCount() > 0) {
                    throw new EvaluationException("Index " + index + " is out of bounds (1 - " + (list.getListCount() + 1) + ").");
                }
                LinkedList<JamochaValue> newList = new LinkedList<JamochaValue>();
                --index;
                for (i = 0; i < index && i < list.getListCount(); ++i) {
                    newList.add(list.getListValue(i));
                }
                for (i = 2; i < params.length; ++i) {
                    JamochaValue value = params[i].getValue(engine);
                    if (value.equals(JamochaValue.NIL)) continue;
                    if (value.is(JamochaType.LIST)) {
                        for (int j = 0; j < value.getListCount(); ++j) {
                            newList.add(value.getListValue(j));
                        }
                        continue;
                    }
                    newList.add(value);
                }
                for (i = index; i < list.getListCount(); ++i) {
                    newList.add(list.getListValue(i));
                }
                JamochaValue[] tmp = new JamochaValue[newList.size()];
                for (int i2 = 0; i2 < newList.size(); ++i2) {
                    tmp[i2] = (JamochaValue)newList.get(i2);
                }
                return JamochaValue.newList(tmp);
            }
            throw new IllegalTypeException(JamochaType.LISTS, list.getType());
        }
        throw new IllegalParameterException(3, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Inserts one or more items into an existing list at a specific position and returns the extended list. If a list of items is inserted each item of it is inserted separately, so there are no nested lists.\nAttention: Lists in Jamocha start with index 1.";
        }

        public int getParameterCount() {
            return 3;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "List to insert one or more items into.";
                }
                case 1: {
                    return "Position where the new item(s) should be added at.";
                }
            }
            return "Item(s) to insert into the List.";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "someList";
                }
                case 1: {
                    return "index";
                }
            }
            return "item";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.LISTS;
                }
                case 1: {
                    return JamochaType.LONGS;
                }
            }
            return JamochaType.ANY;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LISTS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 2;
        }

        public String getExample() {
            return "(insert$ (create$ cheese milk bread sausages) 3 eggs)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "[cheese, milk, eggs, bread, sausages]";
        }
    }
}

