/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import java.util.ArrayList;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Create$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "create$";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null) {
            ArrayList<JamochaValue> newListValues = new ArrayList<JamochaValue>();
            for (int i = 0; i < params.length; ++i) {
                JamochaValue value = params[i].getValue(engine);
                if (value.is(JamochaType.LIST)) {
                    for (int j = 0; j < value.getListCount(); ++j) {
                        newListValues.add(value.getListValue(j));
                    }
                    continue;
                }
                newListValues.add(value);
            }
            JamochaValue[] values = new JamochaValue[newListValues.size()];
            newListValues.toArray(values);
            return JamochaValue.newList(values);
        }
        throw new IllegalParameterException(0, true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Creates a list of the given arguments.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Any value to be part of the list.";
        }

        public String getParameterName(int parameter) {
            return "someValue";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.ANY;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LISTS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return true;
        }

        public String getExample() {
            return "(create$ cheese milk eggs)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "[cheese, milk, eggs]";
        }
    }
}

