/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.list;

import java.util.LinkedList;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Complement$
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "complement$";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 2) {
            JamochaValue listOne = params[0].getValue(engine);
            JamochaValue listTwo = params[1].getValue(engine);
            if (listOne.is(JamochaType.LIST)) {
                if (listTwo.is(JamochaType.LIST)) {
                    if (listTwo.getListCount() < 1) {
                        return JamochaValue.EMPTY_LIST;
                    }
                    if (listOne.getListCount() < 1) {
                        JamochaValue[] res = new JamochaValue[listTwo.getListCount()];
                        for (int i = 0; i < res.length; ++i) {
                            res[i] = listTwo.getListValue(i);
                        }
                        return JamochaValue.newList(res);
                    }
                    int countOne = listOne.getListCount();
                    int countTwo = listTwo.getListCount();
                    LinkedList<JamochaValue> tmp = new LinkedList<JamochaValue>();
                    block1: for (int i = 0; i < countTwo; ++i) {
                        for (int j = 0; j < countOne; ++j) {
                            if (listOne.getListValue(j).equals(listTwo.getListValue(i))) continue block1;
                        }
                        tmp.add(listTwo.getListValue(i));
                    }
                    JamochaValue[] res = new JamochaValue[tmp.size()];
                    for (int i = 0; i < tmp.size(); ++i) {
                        res[i] = (JamochaValue)tmp.get(i);
                    }
                    return JamochaValue.newList(res);
                }
                throw new IllegalTypeException(JamochaType.LISTS, listTwo.getType());
            }
            throw new IllegalTypeException(JamochaType.LISTS, listOne.getType());
        }
        throw new IllegalParameterException(2, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns a new list containing all elements of the second list that are not also elements of the first list.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "List acting as a filter for list two.";
                }
                case 1: {
                    return "List that is filtered by list one.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "listOne";
                }
                case 1: {
                    return "listTwo";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.LISTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LISTS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(complement$  (create$ sausage milk eggs) (create$ cheese milk eggs bread))";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

