/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.functions.java.ClassnameResolver;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class New
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "new";
    private final ClassnameResolver classnameResolver;

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public New(ClassnameResolver classnameResolver) {
        this.classnameResolver = classnameResolver;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        Object o = null;
        String classname = null;
        Object[] args = null;
        if (params != null && params.length > 0) {
            classname = params[0].getValue(engine).getStringValue();
            args = new Object[params.length - 1];
            for (int idx = 1; idx < params.length; ++idx) {
                args[idx - 1] = params[idx].getValue(engine).getObjectValue();
            }
            try {
                Class<?> classDefinition = this.classnameResolver.resolveClass(classname);
                Constructor<?> foundConstructor = null;
                for (Constructor<?> constructor : classDefinition.getConstructors()) {
                    Class<?>[] parameterClasses = constructor.getParameterTypes();
                    if (parameterClasses.length != args.length) continue;
                    boolean match = true;
                    for (int i = 0; i < parameterClasses.length; ++i) {
                        match &= parameterClasses[i].isInstance(args[i]) || args[i] == null;
                    }
                    if (!match) continue;
                    foundConstructor = constructor;
                    break;
                }
                if (foundConstructor != null) {
                    o = foundConstructor.newInstance(args);
                }
                return JamochaValue.newObject(o);
            }
            catch (ClassNotFoundException e) {
                throw new EvaluationException(e);
            }
            catch (InstantiationException e) {
                throw new EvaluationException(e);
            }
            catch (IllegalAccessException e) {
                throw new EvaluationException(e);
            }
            catch (SecurityException e) {
                throw new EvaluationException(e);
            }
            catch (IllegalArgumentException e) {
                throw new EvaluationException(e);
            }
            catch (InvocationTargetException e) {
                throw new EvaluationException(e);
            }
        }
        throw new IllegalParameterException(1, true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Creates a Java object and returns it. Searches for the constructor that accepts the appropriate number of parameters.";
        }

        public int getParameterCount() {
            return 3;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Object to instantiate.";
                }
            }
            return "One or more parameters for the constructor.";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "object";
                }
            }
            return "parameter";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.OBJECTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.OBJECTS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

