/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Member
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "member";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        Object o = null;
        String methodname = null;
        Object[] args = null;
        if (params != null && params.length >= 2) {
            o = params[0].getValue(engine).getObjectValue();
            methodname = params[1].getValue(engine).getIdentifierValue();
            args = new Object[params.length - 2];
            for (int idx = 2; idx < params.length; ++idx) {
                args[idx - 2] = params[idx].getValue(engine).getObjectValue();
            }
            try {
                Class<?> classDefinition = o.getClass();
                Method[] methods = classDefinition.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] parameterTypes;
                    Method method = methods[i];
                    if (!method.getName().equals(methodname) || (parameterTypes = method.getParameterTypes()).length != args.length) continue;
                    boolean compatible = true;
                    for (int j = 0; j < args.length && compatible; compatible &= parameterTypes[j].isInstance(args[j]), ++j) {
                    }
                    if (!compatible) continue;
                    return JamochaValue.newObject(method.invoke(o, args));
                }
            }
            catch (IllegalAccessException e) {
                throw new EvaluationException(e);
            }
            catch (SecurityException e) {
                throw new EvaluationException(e);
            }
            catch (IllegalArgumentException e) {
                throw new EvaluationException(e);
            }
            catch (InvocationTargetException e) {
                throw new EvaluationException(e);
            }
        }
        return JamochaValue.FALSE;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Calls a method of a specified object. Returns the resulting value of the method or false.";
        }

        public int getParameterCount() {
            return 3;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Object to call the method of.";
                }
                case 1: {
                    return "Method to call.";
                }
            }
            return "One or more parameters for the method.";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "object";
                }
                case 1: {
                    return "method";
                }
            }
            return "parameter";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.OBJECTS;
                }
                case 1: {
                    return JamochaType.STRINGS;
                }
            }
            return JamochaType.OBJECTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.ANY;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 1;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

