/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.java;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.functions.FunctionGroup;
import org.jamocha.engine.functions.java.ClassnameResolver;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class LoadPackage
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "load-package";
    private final ClassnameResolver classnameResolver;

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public LoadPackage(ClassnameResolver classnameResolver) {
        this.classnameResolver = classnameResolver;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        Object o = null;
        String classname = null;
        if (params != null && params.length == 1) {
            classname = params[0].getValue(engine).getIdentifierValue();
            try {
                Class<?> classDefinition = this.classnameResolver.resolveClass(classname);
                o = classDefinition.newInstance();
                if (o instanceof FunctionGroup) {
                    engine.getFunctionMemory().declareFunctionGroup((FunctionGroup)o);
                    result = JamochaValue.TRUE;
                }
            }
            catch (ClassNotFoundException e) {
                throw new EvaluationException(e);
            }
            catch (InstantiationException e) {
                throw new EvaluationException(e);
            }
            catch (IllegalAccessException e) {
                throw new EvaluationException(e);
            }
            catch (SecurityException e) {
                throw new EvaluationException(e);
            }
            catch (IllegalArgumentException e) {
                throw new EvaluationException(e);
            }
        }
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Creates a Java object and returns true on success.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Classname of the object to create.";
        }

        public String getParameterName(int parameter) {
            return "className";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

