/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.java;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.functions.java.ClassnameResolver;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Instanceof
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "instanceof";
    private final ClassnameResolver classnameResolver;

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public Instanceof(ClassnameResolver classnameResolver) {
        this.classnameResolver = classnameResolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        if (params.length != 2) throw new IllegalParameterException(2);
        Object object = params[0].getValue(engine).getObjectValue();
        String className = params[1].getValue(engine).getIdentifierValue();
        try {
            Class<?> clazz = this.classnameResolver.resolveClass(className);
            if (!clazz.isInstance(object)) return result;
            return JamochaValue.TRUE;
        }
        catch (ClassNotFoundException e) {
            throw new EvaluationException(e);
        }
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Tests whether an object given as first argument is of a certain type, specified in the second argument. Returns true if this is the case, false otherwise.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Object to test.";
                }
                case 1: {
                    return "Name of the class to test for.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "object";
                }
                case 1: {
                    return "class";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.OBJECTS;
                }
                case 1: {
                    return JamochaType.STRINGS;
                }
            }
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

