/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.Expression;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParseException;
import org.jamocha.parser.Parser;
import org.jamocha.parser.ParserFactory;

public class LoadFacts
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "load-facts";
    private StringChannel loadFactsChannel = null;

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        if (params != null && params.length > 0) {
            for (int idx = 0; idx < params.length; ++idx) {
                String input = params[idx].getValue(engine).getStringValue();
                try {
                    InputStream inStream;
                    if (input.matches("^[a-zA-Z]+://.*")) {
                        URL url = new URL(input);
                        inStream = url.openConnection().getInputStream();
                    } else {
                        inStream = new FileInputStream(new File(input));
                    }
                    result = this.assertFacts(engine, new BufferedReader(new InputStreamReader(inStream)));
                    inStream.close();
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new EvaluationException("Error while loading facts from: " + input, e);
                }
                catch (IOException e) {
                    throw new EvaluationException("Error while loading facts from: " + input, e);
                }
                catch (ParseException e) {
                    throw new EvaluationException("Error while loading facts from: " + input, e);
                }
            }
        }
        return result;
    }

    public JamochaValue assertFacts(Engine engine, BufferedReader reader) throws IOException, ParseException, EvaluationException {
        Expression expr;
        if (this.loadFactsChannel == null) {
            this.loadFactsChannel = engine.getMessageRouter().openChannel("loadFactsChannel");
        }
        StringBuilder buffer = new StringBuilder("(assert ");
        while (reader.ready()) {
            buffer.append(reader.readLine());
        }
        buffer.append(")");
        Parser parser = ParserFactory.getParser(new StringReader(buffer.toString()));
        buffer = new StringBuilder();
        while (null != (expr = parser.nextExpression())) {
            JamochaValue result = expr.getValue(engine);
            buffer.append(result.toString());
        }
        engine.writeMessage(buffer.toString());
        return JamochaValue.TRUE;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Reads a file from the given location and surrounds the content with (assert ... ). So a list of facts can be asserted into the rule engine with one single call. The result is true if any of the given files could be parsed successfully.Attention a corresponding Jamocha template must be defined in order to actually import thefacts into the engine.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Path(s) to one or more file(s) containing facts without assert-call to be asserted.";
        }

        public String getParameterName(int parameter) {
            return "fileName";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(deftemplate transaction\n  (slot accountId (type STRING))\n  (slot countryCode (type STRING))\n  (slot cusip (type INTEGER))\n  (slot issuer (type STRING))\n  (slot total (type DOUBLE))\n)\n(load-facts samples/data.clp)\n";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

