/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.jamocha.Constants;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.Expression;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParseException;
import org.jamocha.parser.Parser;
import org.jamocha.parser.ParserFactory;

public class Batch
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "batch";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        if (params != null && params.length > 0) {
            for (int idx = 0; idx < params.length; ++idx) {
                String input = params[idx].getValue(engine).getStringValue();
                try {
                    InputStream inStream;
                    if (input.matches("^[a-zA-Z]+://.*")) {
                        URI url = new URI(input);
                        if (url.getScheme().equals("internal")) {
                            String intPath = url.getAuthority() + url.getPath();
                            inStream = Constants.class.getResourceAsStream(intPath);
                        } else {
                            inStream = url.toURL().openConnection().getInputStream();
                        }
                    } else {
                        File file = new File(input);
                        if (!file.exists()) {
                            String path;
                            String[] paths;
                            String[] arr$ = paths = Engine.getJamochaSearchPaths();
                            int len$ = arr$.length;
                            for (int i$ = 0; i$ < len$ && !(file = new File((path = arr$[i$]) + input)).exists(); ++i$) {
                            }
                        }
                        inStream = new FileInputStream(new File(input));
                    }
                    result = this.parse(engine, inStream);
                    inStream.close();
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new EvaluationException("File not found: " + input, e);
                }
                catch (IOException e) {
                    throw new EvaluationException("Error reading file: " + input, e);
                }
                catch (Exception e) {
                    throw new EvaluationException("Error while parsing file: " + input, e);
                }
            }
        }
        return result;
    }

    public JamochaValue parse(Engine engine, InputStream ins) throws EvaluationException {
        try {
            Parser parser = ParserFactory.getParser(ins);
            Expression expr = null;
            while ((expr = parser.nextExpression()) != null) {
                expr.getValue(engine);
            }
            return JamochaValue.TRUE;
        }
        catch (ParseException e) {
            return JamochaValue.newString(e.getMessage());
        }
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Loads and executes one or more given files. Multiple arguments are separated by a blank. Files can be located on a local drive or on a remote machine accessible via http or some other protocol. Returns true on success.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "File(s) to load and execute.";
        }

        public String getParameterName(int parameter) {
            return "fileName";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(batch samples/view-test.clp)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

