/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.datetime;

import java.util.GregorianCalendar;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class GetGMTOffset
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "getgmtoffset";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 1) {
            GregorianCalendar p1 = params[0].getValue(engine).getDateValue();
            return JamochaValue.newLong(p1.get(15) / 3600000);
        }
        throw new IllegalParameterException(1, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Returns the GMT Offset-field from the given DateTime argument.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "DateTime to get the GMT Offset from.";
        }

        public String getParameterName(int parameter) {
            return "datetime";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.DATETIMES;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LONGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(getgmtoffset 2007-06-04 17:14:06+5)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return 5;
        }
    }
}

