/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.compare;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class AnyEq
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "any-eq";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        if (params != null && params.length > 1) {
            JamochaValue constant = params[0].getValue(engine);
            for (int idx = 1; idx < params.length; ++idx) {
                if (!constant.equals(params[idx].getValue(engine))) continue;
                result = JamochaValue.FALSE;
                break;
            }
        } else {
            throw new IllegalParameterException(1);
        }
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Any-eq is used to compare a literal value against one or more bindings. If any of the bindings is equal to the constant value, the function returns true.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Literal value that should be compared to the other parameters.";
                }
            }
            return "Value that should be compared to the first parameter.";
        }

        public String getParameterName(int parameter) {
            return "value";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.ANY;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

