/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.agent;

import jade.core.AID;
import jade.lang.acl.ACLMessage;
import java.util.Calendar;
import org.jamocha.communication.agent.JamochaAgent;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class AgentSendMessage
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "agent-send-message";
    private final JamochaAgent agent;
    private static final String AGENT_IDENTIFIER = "agent-identifier";
    private static final String AGENT_MESSAGE = "agent-message";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public AgentSendMessage(JamochaAgent agent) {
        this.agent = agent;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params.length == 1) {
            Fact messageFact;
            JamochaValue val = params[0].getValue(engine);
            if (val.is(JamochaType.FACT)) {
                messageFact = val.getFactValue();
            } else if (val.is(JamochaType.FACT_ID) || val.is(JamochaType.LONG)) {
                messageFact = engine.getFactById(val.getLongValue());
            } else {
                throw new EvaluationException("The only parameter of (send-message) must be of type FACT or FACT_ID.");
            }
            if (!messageFact.getTemplate().getName().equals(AGENT_MESSAGE)) {
                throw new EvaluationException("(send-message) expects a fact of type agent-message as parameter.");
            }
            ACLMessage message = this.fillAclMessage(engine, messageFact);
            this.agent.getMessageSender().enqueueMessage(message);
            return JamochaValue.TRUE;
        }
        throw new IllegalParameterException(1);
    }

    private ACLMessage fillAclMessage(Engine engine, Fact messageFact) throws EvaluationException {
        ACLMessage result = new ACLMessage(ACLMessage.getInteger((String)this.slotToString(messageFact, "performative")));
        String sender = this.identifierToString(messageFact.getSlotValue("sender"), engine);
        if (sender.equals("")) {
            sender = this.agent.getName();
        }
        result.setSender(new AID(sender, true));
        JamochaValue receivers = messageFact.getSlotValue("receiver");
        for (int i = 0; i < receivers.getListCount(); ++i) {
            String recv = this.identifierToString(receivers.getListValue(i), engine);
            if (recv.equals("")) continue;
            result.addReceiver(new AID(recv, true));
        }
        JamochaValue replyTo = messageFact.getSlotValue("reply-to");
        for (int i = 0; i < replyTo.getListCount(); ++i) {
            String repl = this.identifierToString(replyTo.getListValue(i), engine);
            if (repl.equals("")) continue;
            result.addReplyTo(new AID(repl, true));
        }
        result.setContent(this.slotToString(messageFact, "content"));
        result.setLanguage(this.slotToString(messageFact, "language"));
        result.setEncoding(this.slotToString(messageFact, "encoding"));
        result.setOntology(this.slotToString(messageFact, "ontology"));
        result.setProtocol(this.slotToString(messageFact, "protocol"));
        result.setConversationId(this.slotToString(messageFact, "conversation-id"));
        result.setInReplyTo(this.slotToString(messageFact, "in-reply-to"));
        result.setReplyWith(this.slotToString(messageFact, "reply-with"));
        JamochaValue repBy = messageFact.getSlotValue("reply-by");
        if (repBy.is(JamochaType.LONG)) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(repBy.getLongValue());
            result.setReplyByDate(cal.getTime());
        }
        return result;
    }

    private String slotToString(Fact messageFact, String slotName) throws EvaluationException {
        return messageFact.getSlotValue(slotName).getStringValue();
    }

    private String identifierToString(JamochaValue idVal, Engine engine) throws EvaluationException {
        String res = "";
        if (!idVal.is(JamochaType.NIL)) {
            Fact idFact = null;
            if (idVal.is(JamochaType.FACT)) {
                idFact = idVal.getFactValue();
            } else if (idVal.is(JamochaType.FACT_ID) || idVal.is(JamochaType.LONG)) {
                idFact = engine.getFactById(idVal.getLongValue());
            }
            if (idFact != null && idFact.getTemplate().getName().equals(AGENT_IDENTIFIER)) {
                res = idFact.getSlotValue("name").getStringValue();
            }
        }
        return res;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "This Function takes a simple agent-message fact and sends it out via the JamochaAgent. If no sender is given the local agent is taken as sender. Always returns true if no error occured.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "An agent-message fact that should be send out as acl message.";
        }

        public String getParameterName(int parameter) {
            return "aclMessage";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.FACTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

