/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.adaptor;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Deffact;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class JDBCLink
extends AbstractFunction {
    private static final long serialVersionUID = -2401053364084360514L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "jdbclink";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 3) {
            Connection conn;
            String action;
            block21: {
                JamochaValue jamochaValue;
                block22: {
                    Slot[] slots;
                    String table;
                    JamochaValue thirdParam;
                    block19: {
                        JamochaValue jamochaValue2;
                        block20: {
                            long jdbclink = params[0].getValue(engine).getFactIdValue();
                            action = params[1].getValue(engine).getStringValue();
                            thirdParam = params[2].getValue(engine);
                            Fact configFact = engine.getFactById(jdbclink);
                            String jdbc_driver = configFact.getSlotValue("JDBCdriver").getStringValue();
                            String jdbc_url = configFact.getSlotValue("JDBCurl").getStringValue();
                            String username = configFact.getSlotValue("Username").getStringValue();
                            String password = configFact.getSlotValue("Password").getStringValue();
                            String tmplt = configFact.getSlotValue("TemplateName").getStringValue();
                            table = configFact.getSlotValue("TableName").getStringValue();
                            try {
                                Class.forName(jdbc_driver).newInstance();
                            }
                            catch (Exception e) {
                                engine.writeMessage("Couldnt load JDBC driver");
                            }
                            Deftemplate template = (Deftemplate)engine.findTemplate(tmplt);
                            slots = template.getAllSlots();
                            conn = null;
                            conn = DriverManager.getConnection(jdbc_url, username, password);
                            if (!action.equals("import")) break block19;
                            jamochaValue2 = this.method_import(engine, thirdParam, table, template, slots, conn);
                            if (conn == null) break block20;
                            try {
                                conn.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        return jamochaValue2;
                    }
                    if (!action.equals("export")) break block21;
                    jamochaValue = this.method_export(engine, thirdParam, table, slots, conn);
                    if (conn == null) break block22;
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                return jamochaValue;
            }
            try {
                try {
                    throw new EvaluationException("Unknown action '" + action + "'");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JamochaValue jamochaValue = JamochaValue.newBoolean(false);
                    return jamochaValue;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        throw new IllegalParameterException(3, false);
    }

    private JamochaValue method_export(Engine engine, JamochaValue thirdParam, String table, Slot[] slots, Connection conn) throws SQLException, EvaluationException {
        int i;
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getPrimaryKeys(null, null, table);
        ArrayList<String> keys = new ArrayList<String>();
        while (rs.next()) {
            keys.add(rs.getString("COLUMN_NAME"));
        }
        String insertStatement = "INSERT INTO " + table + " (" + slots[0].getName();
        for (i = 1; i < slots.length; ++i) {
            insertStatement = insertStatement + "," + slots[i].getName();
        }
        insertStatement = insertStatement + ") VALUES (?";
        for (i = 1; i < slots.length; ++i) {
            insertStatement = insertStatement + ",?";
        }
        insertStatement = insertStatement + ")";
        String updateStatement = "UPDATE " + table + " SET " + slots[0].getName() + "=?";
        for (int i2 = 1; i2 < slots.length; ++i2) {
            updateStatement = updateStatement + "," + slots[i2].getName() + "=?";
        }
        updateStatement = updateStatement + " WHERE ";
        boolean firstKey = true;
        for (String key : keys) {
            if (!firstKey) {
                updateStatement = updateStatement + " AND ";
            }
            firstKey = false;
            updateStatement = updateStatement + key + "=?";
        }
        String lookupStatement = "SELECT * FROM " + table + " WHERE ";
        firstKey = true;
        for (String key : keys) {
            if (!firstKey) {
                lookupStatement = lookupStatement + " AND ";
            }
            firstKey = false;
            lookupStatement = lookupStatement + key + "=?";
        }
        PreparedStatement inserter = conn.prepareStatement(insertStatement);
        PreparedStatement updater = conn.prepareStatement(updateStatement);
        PreparedStatement lookuper = conn.prepareStatement(lookupStatement);
        for (int i3 = 0; i3 < thirdParam.getListCount(); ++i3) {
            int j;
            Fact actFact = engine.getFactById(thirdParam.getListValue(i3).getFactIdValue());
            boolean insert = true;
            if (keys.size() > 0) {
                int keyindex = 1;
                for (String key : keys) {
                    lookuper.setObject(keyindex++, actFact.getSlotValue(key).getObjectValue());
                }
                insert = !lookuper.executeQuery().next();
            }
            PreparedStatement actor = insert ? inserter : updater;
            for (j = 1; j <= slots.length; ++j) {
                Object o = actFact.getSlotValue(slots[j - 1].getName()).getObjectValue();
                if (o instanceof GregorianCalendar) {
                    o = ((GregorianCalendar)o).getTime();
                }
                actor.setObject(j, o);
            }
            if (!insert) {
                j = slots.length + 1;
                for (String key : keys) {
                    Object o = actFact.getSlotValue(key).getObjectValue();
                    if (o instanceof GregorianCalendar) {
                        o = ((GregorianCalendar)o).getTime();
                    }
                    actor.setObject(j++, o);
                }
            }
            actor.execute();
        }
        return JamochaValue.newBoolean(true);
    }

    private JamochaValue method_import(Engine engine, JamochaValue conditions, String table, Deftemplate template, Slot[] slots, Connection conn) throws SQLException, EvaluationException {
        int i;
        StringBuffer statementString = new StringBuffer();
        statementString.append("SELECT ");
        statementString.append(slots[0].getName());
        for (i = 1; i < slots.length; ++i) {
            statementString.append(",");
            statementString.append(slots[i].getName());
        }
        statementString.append(" FROM ");
        statementString.append(table);
        for (i = 0; i < conditions.getListCount(); ++i) {
            Fact actCondition = engine.getFactById(conditions.getListValue(i).getFactIdValue());
            String slotname = actCondition.getSlotValue("SlotName").getStringValue();
            String operator = actCondition.getSlotValue("BooleanOperator").getStringValue();
            if (i == 0) {
                statementString.append(" WHERE (");
            } else {
                statementString.append(" AND (");
            }
            statementString.append(slotname);
            statementString.append(operator);
            statementString.append("?) ");
        }
        PreparedStatement stmt = conn.prepareStatement(statementString.toString());
        for (int i2 = 0; i2 < conditions.getListCount(); ++i2) {
            Fact actCondition = engine.getFactById(conditions.getListValue(i2).getFactIdValue());
            Object value = actCondition.getSlotValue("Value").getObjectValue();
            if (value instanceof GregorianCalendar) {
                GregorianCalendar gregval = (GregorianCalendar)value;
                value = new Date(gregval.getTimeInMillis() + (long)gregval.get(15));
            }
            stmt.setObject(i2 + 1, value);
        }
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            Slot[] rowValues = new Slot[slots.length];
            for (int i3 = 0; i3 < slots.length; ++i3) {
                Object o = rs.getObject(slots[i3].getName());
                if (o instanceof java.util.Date) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime((java.util.Date)o);
                    o = cal;
                }
                JamochaValue val = JamochaValue.newValueAutoType(o);
                rowValues[i3] = new Slot(slots[i3].getName(), val);
            }
            Deffact rowFact = new Deffact(template, rowValues);
            engine.assertFact(rowFact);
        }
        return JamochaValue.newBoolean(true);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Imports or exports facts to and from a database via a jdbc link.\nOn import for each line of the DB-table a fact of a corresponding Jamocha template is asserted. Therefore an adequate template has to be defined before an import can take place.\nOn export for each fact in a fact-list a new record is inserted into the DB-table or an existing record is updated (according to the contents of the primary key). The facts have to be based on a well-defined template. Exporting incomplete templates may cause inconsistencies.Returns true on success";
        }

        public int getParameterCount() {
            return 3;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "Fact describing the jdbc link connection to use.";
                }
                case 1: {
                    return "Operation is either \"import\" or \"export\".";
                }
                case 2: {
                    return "On export: fact-list to export. On import: list of jdbccondition-facts for filtering.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return JDBCLink.NAME;
                }
                case 1: {
                    return "operation";
                }
                case 2: {
                    return "facts";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.FACT_IDS;
                }
                case 1: {
                    return JamochaType.STRINGS;
                }
                case 2: {
                    return JamochaType.LISTS;
                }
            }
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.BOOLEANS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate templ (slot a) (slot b) (slot c) (slot foo) )\n(jdbclink-init)\n(bind ?mylink\n\t(assert\n\t\t(jdbclink\n\t\t\t(JDBCdriver \"com.mysql.jdbc.Driver\")\n\t\t\t(ConnectionName \"db\")\n\t\t\t(TableName \"test\")\n\t\t\t(TemplateName \"templ\")\n\t\t\t(Username \"jamocha\")\n\t\t\t(Password \"geheim\")\n\t\t\t(JDBCurl \"jdbc:mysql://134.130.113.67:3306/jamocha\")\n\t\t)\n\t)\n)\n(bind ?myfilter\n\t(assert\n\t\t(jdbccondition\n\t\t\t(SlotName \"foo\")\n\t\t\t(BooleanOperator \">\")\n\t\t\t(Value 2007-04-27 19:00+1)\n\t\t)\n\t)\n)\n(jdbclink ?mylink \"import\" (create$ ?myfilter))\n\n(deftemplate templ2 (slot a) (slot b) (slot c) )\n(jdbclink-init)\n(bind ?mylink\n\t(assert\n\t\t(jdbclink\n\t\t\t\t(JDBCdriver \"com.mysql.jdbc.Driver\")\n\t\t\t\t(ConnectionName \"db\")\n\t\t\t\t(TableName \"test\")\n\t\t\t\t(TemplateName \"templ2\")\n\t\t\t\t(Username \"jamocha\")\n\t\t\t\t(Password \"geheim\")\n\t\t\t\t(JDBCurl \"jdbc:mysql://134.130.113.67:65306/jamocha\")\n\t\t)\n\t)\n)\n(assert (templ2 (a 99) (b 99) (c \"neunviermal\")) )\n(jdbclink ?mylink \"export\" \"3\"  )";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

