/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.adaptor;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.util.DeffactIterator;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class IteratorImporter
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    public static final FunctionDescription DESCRIPTION = new Description();
    public static final String NAME = "iteratorimporter";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 2) {
            Class<?> iteratorclass = null;
            try {
                iteratorclass = Class.forName(params[0].getValue(engine).getStringValue());
            }
            catch (ClassNotFoundException e1) {
                return JamochaValue.FALSE;
            }
            Fact configFact = engine.getFactById(params[1].getValue(engine).getFactIdValue());
            Template configtemplate = configFact.getTemplate();
            TemplateSlot[] keys = configtemplate.getAllSlots();
            HashMap<String, String> configMap = new HashMap<String, String>();
            for (TemplateSlot key : keys) {
                configMap.put(key.getName(), configFact.getSlotValue(key.getName()).getStringValue());
            }
            Constructor<?> ourConstructor = null;
            for (Constructor<?> c : iteratorclass.getConstructors()) {
                if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isAssignableFrom(Map.class)) continue;
                ourConstructor = c;
            }
            if (ourConstructor == null) {
                return JamochaValue.FALSE;
            }
            Object[] constructorparams = new Object[]{configMap};
            DeffactIterator ourIterator = null;
            try {
                ourIterator = (DeffactIterator)ourConstructor.newInstance(constructorparams);
                while (ourIterator.hasNext()) {
                    engine.assertFact(ourIterator.next());
                }
            }
            catch (Exception e) {
                return JamochaValue.FALSE;
            }
            return JamochaValue.TRUE;
        }
        throw new IllegalParameterException(2, false);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Imports facts from an external, user-defined iterator to the rete engine. The external iterator isspecified in the first argument and needs to be a user-implementation of a subclass of org.jamocha.rete.util.DeffactIterator.  The function generates a mapping from the config-fact given in the second argument. After that itasserts a fact from each deffact the iterator returns. Returns true, iff everything went fine.";
        }

        public int getParameterCount() {
            return 2;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "User-defined iterator, class name of a subclass of org.jamocha.rete.util.DeffactIterator.";
                }
                case 1: {
                    return "Config-fact, to generate a mapping for the import from.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "DeffactIteratorClass";
                }
                case 1: {
                    return "ConfigFact";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            switch (parameter) {
                case 0: {
                    return JamochaType.STRINGS;
                }
                case 1: {
                    return JamochaType.FACT_IDS;
                }
            }
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.LONGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(deftemplate fibonacciconfig (slot max))\n(bind ?config\t(assert\t(fibonacciconfig (max \"1000\"))))\n(iteratorimporter \"org.jamocha.sampleimplementations.DeffactFibonacciIterator\" ?config)\n(facts)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

