/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions;

import org.jamocha.engine.BoundParam;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ExpressionSequence;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.scope.BlockingScope;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.Expression;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class InterpretedFunction
extends AbstractFunction {
    private static final long serialVersionUID = 1L;
    private final FunctionDescription description = new InterpretedFunctionDescription();
    private String name = null;
    private String descriptionText = null;
    protected Expression[] inputParams = null;
    private ExpressionSequence actions = null;

    public InterpretedFunction(String name, String descriptionText, Expression[] params, ExpressionSequence actions) {
        this.name = name;
        this.descriptionText = descriptionText;
        this.inputParams = params;
        this.actions = actions;
    }

    public FunctionDescription getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        JamochaValue result = JamochaValue.NIL;
        if (params.length == this.inputParams.length) {
            int idx;
            JamochaValue[] evaluatedParams = new JamochaValue[this.inputParams.length];
            for (idx = 0; idx < this.inputParams.length; ++idx) {
                evaluatedParams[idx] = params[idx].getValue(engine);
            }
            engine.pushScope(new BlockingScope());
            for (idx = 0; idx < this.inputParams.length; ++idx) {
                BoundParam bp = (BoundParam)this.inputParams[idx];
                engine.setBinding(bp.getVariableName(), evaluatedParams[idx]);
            }
            try {
                result = this.actions.getValue(engine);
            }
            catch (Exception e) {
                throw new EvaluationException("Unknown Error in function " + this.name, e);
            }
            finally {
                engine.popScope();
            }
        } else {
            throw new IllegalParameterException(this.inputParams.length);
        }
        return result;
    }

    private class InterpretedFunctionDescription
    implements FunctionDescription {
        private InterpretedFunctionDescription() {
        }

        public String getDescription() {
            return InterpretedFunction.this.descriptionText;
        }

        public int getParameterCount() {
            if (InterpretedFunction.this.inputParams != null) {
                return InterpretedFunction.this.inputParams.length;
            }
            return 0;
        }

        public String getParameterDescription(int parameter) {
            return "- not available -";
        }

        public String getParameterName(int parameter) {
            if (InterpretedFunction.this.inputParams != null && parameter < InterpretedFunction.this.inputParams.length && parameter >= 0) {
                BoundParam bp = (BoundParam)InterpretedFunction.this.inputParams[parameter];
                return bp.getVariableName();
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            if (InterpretedFunction.this.inputParams != null && parameter < InterpretedFunction.this.inputParams.length && parameter >= 0) {
                return JamochaType.ANY;
            }
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.ANY;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

