/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.functions.DeffunctionGroup;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.functions.FunctionGroup;
import org.jamocha.engine.functions.FunctionMemory;
import org.jamocha.engine.functions.FunctionNotFoundException;
import org.jamocha.engine.functions.If;
import org.jamocha.engine.functions.InterpretedFunction;
import org.jamocha.engine.functions.LoopForCount;
import org.jamocha.engine.functions.Return;
import org.jamocha.engine.functions.While;
import org.jamocha.engine.functions.adaptor.AdaptorFunctions;
import org.jamocha.engine.functions.compare.CompareFunctions;
import org.jamocha.engine.functions.datetime.DateTimeFunctions;
import org.jamocha.engine.functions.help.HelpFunctions;
import org.jamocha.engine.functions.io.IOFunctions;
import org.jamocha.engine.functions.java.JavaFunctions;
import org.jamocha.engine.functions.list.ListFunctions;
import org.jamocha.engine.functions.math.MathFunctions;
import org.jamocha.engine.functions.ruleengine.RuleEngineFunctions;
import org.jamocha.engine.functions.strings.StringFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionMemoryImpl
implements FunctionMemory {
    private static final long serialVersionUID = 1L;
    protected Engine engine = null;
    protected Map<String, Function> functions = new HashMap<String, Function>();
    protected Map<String, Function> aliases = new HashMap<String, Function>();
    protected final String UNDEFINED_GROUP_NAME = "UNDEFINED";
    private final Map<String, FunctionGroup> functionGroups = new HashMap<String, FunctionGroup>();
    private List<FunctionGroup> builtInFunctionGroups;
    private List<Function> builtInFunctions;

    public FunctionMemoryImpl(Engine engine) {
        this.engine = engine;
    }

    @Override
    public void init() {
        this.builtInFunctionGroups = new ArrayList<FunctionGroup>();
        this.builtInFunctions = new ArrayList<Function>();
        this.registerStaticallyBuiltInFunctions();
        this.loadBuiltInFunctions();
    }

    @Override
    public void registerBuildInFunctionGroup(FunctionGroup funcGroup) {
        this.builtInFunctionGroups.add(funcGroup);
    }

    @Override
    public void registerBuildInFunction(Function func) {
        this.builtInFunctions.add(func);
    }

    private void registerStaticallyBuiltInFunctions() {
        this.builtInFunctionGroups.add(new IOFunctions());
        this.builtInFunctionGroups.add(new MathFunctions());
        this.builtInFunctionGroups.add(new CompareFunctions());
        this.builtInFunctionGroups.add(new DateTimeFunctions());
        this.builtInFunctionGroups.add(new ListFunctions());
        this.builtInFunctionGroups.add(new AdaptorFunctions());
        this.builtInFunctionGroups.add(new RuleEngineFunctions());
        this.builtInFunctionGroups.add(new StringFunctions());
        this.builtInFunctionGroups.add(new JavaFunctions());
        this.builtInFunctionGroups.add(new HelpFunctions());
        this.builtInFunctions.add(new If());
        this.builtInFunctions.add(new LoopForCount());
        this.builtInFunctions.add(new Return());
        this.builtInFunctions.add(new While());
    }

    @Override
    public void clear() {
        this.clearBuiltInFunctions();
        this.loadBuiltInFunctions();
    }

    @Override
    public Function findFunction(String name) throws FunctionNotFoundException {
        Function result = this.functions.get(name);
        if (result == null) {
            result = this.aliases.get(name);
        }
        if (result == null) {
            Logging.logger(this.getClass()).warn("Cannot find requested function '" + name + "'");
            throw new FunctionNotFoundException(name);
        }
        return result;
    }

    @Override
    public void declareFunction(Function func) {
        this.functions.put(func.getName(), func);
        List<String> aliases = func.getAliases();
        for (String alias : aliases) {
            this.aliases.put(alias, func);
        }
        if (func instanceof InterpretedFunction) {
            this.declareFunctionInDefaultGroup(func);
        }
    }

    @Override
    public void declareFunction(Function func, String functionGroupName) {
        this.functions.put(func.getName(), func);
        List<String> aliases = func.getAliases();
        for (String alias : aliases) {
            this.aliases.put(alias, func);
        }
        if (func instanceof InterpretedFunction) {
            this.declareFunctionInGroup(func, functionGroupName);
        }
    }

    @Override
    public void declareFunction(String name) throws ClassNotFoundException {
        try {
            Class<?> fclaz = Class.forName(name);
            Function func = (Function)fclaz.newInstance();
            this.declareFunction(func);
        }
        catch (ClassNotFoundException e) {
            Logging.logger(this.getClass()).warn(e);
            throw e;
        }
        catch (IllegalAccessException e) {
            Logging.logger(this.getClass()).warn(e);
        }
        catch (InstantiationException e) {
            Logging.logger(this.getClass()).warn(e);
        }
    }

    @Override
    public void declareFunctionGroup(String name) {
        try {
            Class<?> fclaz = Class.forName(name);
            FunctionGroup group = (FunctionGroup)fclaz.newInstance();
            this.declareFunctionGroup(group);
        }
        catch (ClassNotFoundException e) {
            Logging.logger(this.getClass()).warn(e);
        }
        catch (IllegalAccessException e) {
            Logging.logger(this.getClass()).warn(e);
        }
        catch (InstantiationException e) {
            Logging.logger(this.getClass()).warn(e);
        }
    }

    @Override
    public void declareFunctionGroup(FunctionGroup functionGroup) {
        this.functionGroups.put(functionGroup.getName(), functionGroup);
        functionGroup.loadFunctions(this);
    }

    protected void loadBuiltInFunctions() {
        for (FunctionGroup funcGroup : this.builtInFunctionGroups) {
            this.declareFunctionGroup(funcGroup);
        }
        for (Function func : this.builtInFunctions) {
            this.declareFunction(func);
        }
    }

    @Override
    public void clearBuiltInFunctions() {
        this.functions.clear();
        this.functionGroups.clear();
        this.aliases.clear();
    }

    @Override
    public Map<String, FunctionGroup> getFunctionGroups() {
        return this.functionGroups;
    }

    @Override
    public Collection<Function> getAllFunctions() {
        return this.functions.values();
    }

    public List<Function> getFunctionsOfGroup(String name) {
        FunctionGroup group = this.functionGroups.get(name);
        if (group != null) {
            return group.listFunctions();
        }
        return Collections.emptyList();
    }

    protected void declareFunctionInGroup(Function function, String groupName) {
        FunctionGroup group = this.getOrCreateDefaultFunctionGroup(groupName);
        group.addFunction(function);
    }

    protected FunctionGroup getOrCreateDefaultFunctionGroup(String groupName) {
        FunctionGroup group;
        if (groupName == null || groupName == "") {
            groupName = "UNDEFINED";
        }
        if ((group = this.functionGroups.get(groupName)) == null) {
            group = new DeffunctionGroup(groupName);
            this.functionGroups.put(groupName, group);
        }
        return group;
    }

    protected void declareFunctionInDefaultGroup(Function function) {
        FunctionGroup group = this.getOrCreateDefaultFunctionGroup("UNDEFINED");
        group.addFunction(function);
    }
}

