/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.configurations;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.engine.BoundParam;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.AbstractSignature;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.functions.FunctionNotFoundException;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signature
extends AbstractSignature
implements Cloneable {
    private static final long serialVersionUID = 1L;
    protected String signatureName = null;
    private Parameter[] params = null;

    public Signature() {
    }

    @Override
    public Object clone() {
        Signature result = new Signature();
        result.setSignatureName(this.signatureName);
        result.setParameters((Parameter[])this.params.clone());
        return result;
    }

    public Signature(String signatureName) {
        this.signatureName = signatureName;
    }

    public void setSignatureName(String name) {
        this.signatureName = name;
    }

    public String getSignatureName() {
        return this.signatureName;
    }

    public Parameter[] getParameters() {
        return this.params;
    }

    public void setParameters(Parameter[] params) {
        this.params = params;
    }

    public void setParameters(List<Parameter> p) {
        Parameter[] params = new Parameter[p.size()];
        for (int i = 0; i < p.size(); ++i) {
            params[i] = p.get(i);
        }
        this.setParameters(params);
    }

    public List<BoundParam> getBoundParameters() {
        ArrayList<BoundParam> result = new ArrayList<BoundParam>();
        for (Parameter param : this.params) {
            if (param instanceof BoundParam) {
                result.add((BoundParam)param);
                continue;
            }
            if (!(param instanceof Signature)) continue;
            result.addAll(((Signature)param).getBoundParameters());
        }
        return result;
    }

    public Function lookUpFunction(Engine engine) throws FunctionNotFoundException {
        return engine.getFunctionMemory().findFunction(this.signatureName);
    }

    public JamochaType getValueType() {
        return JamochaType.UNDEFINED;
    }

    @Override
    public JamochaValue getValue(Engine engine) throws EvaluationException {
        if (this.params != null) {
            Function func;
            try {
                func = this.lookUpFunction(engine);
            }
            catch (FunctionNotFoundException e) {
                throw new EvaluationException(e);
            }
            return func.executeFunction(engine, this.params);
        }
        return JamochaValue.FALSE;
    }

    public void reset() {
        this.params = null;
    }

    @Override
    public String getExpressionString() {
        return this.format(ParserFactory.getFormatter());
    }

    public String toString() {
        return this.format(ParserFactory.getFormatter());
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }
}

