/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.agenda;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ExecuteException;
import org.jamocha.engine.agenda.Agenda;
import org.jamocha.engine.agenda.BreadthStrategy;
import org.jamocha.engine.agenda.ConflictResolutionStrategy;
import org.jamocha.engine.modules.Module;
import org.jamocha.parser.EvaluationException;
import org.jamocha.settings.JamochaSettings;
import org.jamocha.settings.SettingsChangedListener;

public class Agendas {
    protected Map<Module, Agenda> agendas;
    protected Engine parentEngine;
    private final String[] interestedProperties = new String[]{"engine.general_settings.profile_fire", "engine.general_settings.profile_add_activation", "engine.general_settings.profile_remove_activation", "engine.general_settings.watch_activations", "engine.strategy_settings.strategy_main"};
    protected boolean watchActivations = false;
    protected boolean profileFire = false;
    protected boolean profileAddActivation = false;
    protected boolean profileRemoveActivation = false;
    protected ConflictResolutionStrategy strategy = new BreadthStrategy();

    public Agendas(Engine engine) {
        this.parentEngine = engine;
        this.agendas = new HashMap<Module, Agenda>();
        JamochaSettings.getInstance().addListener(new AgendasSettingsChangedListener(), this.interestedProperties);
    }

    public Agenda getAgenda(Module module) {
        Agenda a = this.agendas.get(module);
        if (a == null) {
            a = new Agenda(this.parentEngine, this.strategy, this.watchActivations, this.profileFire, this.profileAddActivation, this.profileRemoveActivation);
            this.agendas.put(module, a);
        }
        return a;
    }

    public int fireFocus(int maxFire) throws ExecuteException {
        Module focus = this.parentEngine.getCurrentFocus();
        Agenda agendaFocus = this.getAgenda(focus);
        return agendaFocus.fire(maxFire);
    }

    public int fireFocus() throws ExecuteException {
        Module focus = this.parentEngine.getCurrentFocus();
        Agenda agendaFocus = this.getAgenda(focus);
        return agendaFocus.fire();
    }

    public void setWatchActivations(boolean watch) {
        this.watchActivations = watch;
        Collection<Agenda> ags = this.agendas.values();
        for (Agenda agenda : ags) {
            agenda.setWatchActivations(watch);
        }
    }

    public void setProfileAddActivation(boolean b) {
        this.profileAddActivation = b;
        Collection<Agenda> ags = this.agendas.values();
        for (Agenda agenda : ags) {
            agenda.setProfileAddActivation(b);
        }
    }

    public void setProfileRemoveActivation(boolean b) {
        this.profileRemoveActivation = b;
        Collection<Agenda> ags = this.agendas.values();
        for (Agenda agenda : ags) {
            agenda.setProfileRemoveActivation(b);
        }
    }

    public void setProfileFire(boolean b) {
        this.profileFire = b;
        Collection<Agenda> ags = this.agendas.values();
        for (Agenda agenda : ags) {
            agenda.setProfileFire(b);
        }
    }

    public void setStrategy(String strategyName) throws EvaluationException {
        try {
            this.strategy = ConflictResolutionStrategy.getStrategy(strategyName);
            Collection<Agenda> ags = this.agendas.values();
            for (Agenda agenda : ags) {
                agenda.setConflictResolutionStrategy(this.strategy);
            }
        }
        catch (InstantiationException e) {
            throw new EvaluationException("Error while setting the strategy to " + strategyName, e);
        }
        catch (IllegalAccessException e) {
            throw new EvaluationException("Error while setting the strategy to " + strategyName, e);
        }
    }

    public void removeActivations() {
        Collection<Agenda> ags = this.agendas.values();
        for (Agenda agenda : ags) {
            agenda.removeActivation();
        }
    }

    private class AgendasSettingsChangedListener
    implements SettingsChangedListener {
        private AgendasSettingsChangedListener() {
        }

        public void settingsChanged(String propertyName) {
            JamochaSettings settings = JamochaSettings.getInstance();
            if (propertyName.equals("engine.general_settings.watch_activations")) {
                Agendas.this.setWatchActivations(settings.getBoolean(propertyName));
            } else if (propertyName.equals("engine.general_settings.profile_fire")) {
                Agendas.this.setProfileFire(settings.getBoolean(propertyName));
            } else if (propertyName.equals("engine.general_settings.profile_add_activation")) {
                Agendas.this.setProfileAddActivation(settings.getBoolean(propertyName));
            } else if (propertyName.equals("engine.general_settings.profile_remove_activation")) {
                Agendas.this.setProfileRemoveActivation(settings.getBoolean(propertyName));
            } else if (propertyName.equals("engine.strategy_settings.strategy_main")) {
                try {
                    Agendas.this.setStrategy(settings.getString(propertyName));
                }
                catch (EvaluationException e) {
                    Logging.logger(this.getClass()).warn(e);
                }
            }
        }
    }
}

