/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.agenda;

import java.io.Serializable;
import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ExecuteException;
import org.jamocha.engine.agenda.Activation;
import org.jamocha.engine.agenda.ConflictResolutionStrategy;
import org.jamocha.engine.util.ProfileStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agenda
implements Serializable {
    private static final int INITIAL_CAPACITY = 10;
    private static final long serialVersionUID = 1L;
    protected Engine parentEngine;
    protected ConflictResolutionStrategy strategy = null;
    protected Queue<Activation> activations;
    protected boolean watchActivations = false;
    protected boolean profileFire = false;
    protected boolean profileAddActivation = false;
    protected boolean profileRemoveActivation = false;

    public Agenda(Engine engine, ConflictResolutionStrategy strategy, boolean watch, boolean profileFire, boolean profileAddActivation, boolean profileRemoveActivation) {
        this.parentEngine = engine;
        this.strategy = strategy;
        this.watchActivations = watch;
        this.profileFire = profileFire;
        this.profileAddActivation = profileAddActivation;
        this.profileRemoveActivation = profileRemoveActivation;
        this.activations = new PriorityQueue<Activation>(10, strategy);
    }

    public void setConflictResolutionStrategy(ConflictResolutionStrategy strat) {
        if (strat == null) {
            throw new NullPointerException();
        }
        this.strategy = strat;
        Queue<Activation> oldList = this.activations;
        int oldListSize = oldList.size();
        int newInitialCapacity = oldListSize > 0 ? oldListSize : 10;
        this.activations = new PriorityQueue<Activation>(newInitialCapacity, this.strategy);
        this.activations.addAll(oldList);
    }

    public ConflictResolutionStrategy getConflictResolutionStrategy() {
        return this.strategy;
    }

    public void addActivation(Activation a) {
        Logging.logger(this.getClass()).debug("adding activation " + a);
        if (this.profileAddActivation) {
            ProfileStats.startAddActivation();
        }
        this.activations.offer(a);
        if (this.profileAddActivation) {
            ProfileStats.endAddActivation();
        }
    }

    public void removeActivation(Activation a) {
        Logging.logger(this.getClass()).debug("removing activation " + a);
        if (this.profileAddActivation) {
            ProfileStats.startAddActivation();
        }
        this.activations.remove(a);
        if (this.profileAddActivation) {
            ProfileStats.endAddActivation();
        }
    }

    public Collection<Activation> getActivations() {
        return this.activations;
    }

    protected void fireNextActivation(Queue<Activation> acts) throws ExecuteException {
        Activation a = acts.poll();
        a.fire(this.parentEngine);
    }

    public int fire(int maxFire) throws ExecuteException {
        int fireCount = 0;
        if (this.profileFire) {
            ProfileStats.startFire();
        }
        while (this.activations.size() > 0 && fireCount < maxFire) {
            this.fireNextActivation(this.activations);
            ++fireCount;
        }
        if (this.profileFire) {
            ProfileStats.endFire();
        }
        return fireCount;
    }

    public int fire() throws ExecuteException {
        int fireCount = 0;
        while (!this.activations.isEmpty()) {
            this.fireNextActivation(this.activations);
            ++fireCount;
        }
        return fireCount;
    }

    public void setWatchActivations(boolean watch) {
        this.watchActivations = watch;
    }

    public void setProfileAddActivation(boolean profileAddActivation) {
        this.profileAddActivation = profileAddActivation;
    }

    public void setProfileFire(boolean profileFire) {
        this.profileFire = profileFire;
    }

    public void setProfileRemoveActivation(boolean profileRemoveActivation) {
        this.profileRemoveActivation = profileRemoveActivation;
    }

    void removeActivation() {
        this.activations.clear();
    }

    public void autoFire(Activation act) throws ExecuteException {
        new AutofireThread(act).start();
    }

    protected class AutofireThread
    extends Thread {
        Activation act;

        public AutofireThread(Activation act) {
            this.act = act;
        }

        public void run() {
            try {
                this.act.fire(Agenda.this.parentEngine);
            }
            catch (ExecuteException e) {
                Logging.logger(this.getClass()).info(e);
            }
        }
    }
}

