/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine;

import java.util.HashMap;
import java.util.Map;
import org.jamocha.engine.AssertException;
import org.jamocha.engine.Engine;
import org.jamocha.engine.RetractException;
import org.jamocha.engine.TemporalThread;
import org.jamocha.engine.TemporalValidity;
import org.jamocha.engine.workingmemory.elements.Fact;

public class TemporalFactThread
extends TemporalThread {
    protected Map<TemporalValidity.EventPoint, Fact> eventPoint2Fact = new HashMap<TemporalValidity.EventPoint, Fact>();
    protected Map<Fact, TemporalValidity.EventPoint> fact2nextEventPoint = new HashMap<Fact, TemporalValidity.EventPoint>();

    public TemporalFactThread(Engine e) {
        super(e, "Temporal Fact Thread");
    }

    protected void handle(TemporalValidity.EventPoint nextEventPoint) {
        Fact f = this.eventPoint2Fact.get(nextEventPoint);
        if (nextEventPoint.getType() == TemporalValidity.EventPoint.Type.START) {
            try {
                this.engine.hardAssertFact(f);
            }
            catch (AssertException e) {
                this.notifyForException(e);
            }
        } else {
            try {
                this.engine.hardRetractFact(f);
            }
            catch (RetractException e) {
                this.notifyForException(e);
            }
        }
    }

    public synchronized void insertFact(Fact f) {
        TemporalValidity.EventPoint e = f.getTemporalValidity().getNextEvent(TemporalFactThread.now());
        this.eventPoint2Fact.put(e, f);
        this.fact2nextEventPoint.put(f, e);
        this.eventPoints.add(e);
        this.notify();
    }

    public synchronized void removeFact(Fact f) {
        this.eventPoint2Fact.values().remove(f);
        TemporalValidity.EventPoint ep = this.fact2nextEventPoint.get(f);
        this.eventPoints.remove(ep);
        this.fact2nextEventPoint.remove(f);
        this.notify();
    }

    protected void skipToNextEventPoint(TemporalValidity.EventPoint actEventPoint) {
        Fact f = this.eventPoint2Fact.get(actEventPoint);
        TemporalValidity.EventPoint newEP = f.getTemporalValidity().getNextEvent(actEventPoint.getTimestamp() + 1L);
        this.eventPoints.add(newEP);
        this.eventPoint2Fact.put(newEP, f);
        this.fact2nextEventPoint.put(f, newEP);
        this.eventPoint2Fact.remove(actEventPoint);
    }
}

