/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jamocha.engine.AssertException;
import org.jamocha.engine.Engine;
import org.jamocha.engine.RetractException;
import org.jamocha.engine.RuleCompiler;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.RootNode;
import org.jamocha.engine.nodes.TerminalNode;
import org.jamocha.engine.rules.rulecompiler.CompileRuleException;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryImpl;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.ParserFactory;
import org.jamocha.parser.RuleException;
import org.jamocha.rules.Rule;
import org.jamocha.settings.JamochaSettings;
import org.jamocha.settings.SettingsChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteNet
implements SettingsChangedListener,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Engine engine = null;
    protected RootNode root = null;
    protected RuleCompiler compiler = null;
    protected WorkingMemory workingMemory;
    private int lastNodeId = 0;
    private boolean shareNodes = true;
    private final String[] interestedProperties = new String[]{"engine.net_settings.share_nodes"};

    public ReteNet(Engine engine) {
        this.engine = engine;
        this.workingMemory = WorkingMemoryImpl.getWorkingMemory();
        this.root = new RootNode(this.nextNodeId(), this.workingMemory, this);
        this.compiler = ParserFactory.getRuleCompiler(engine, this, this.root);
        JamochaSettings.getInstance().addListener(this, this.interestedProperties);
    }

    public synchronized void assertFact(Fact fact) throws AssertException {
        try {
            this.root.addWME(null, fact);
        }
        catch (NodeException e) {
            throw new AssertException(e);
        }
    }

    public synchronized void retractFact(Fact fact) throws RetractException {
        try {
            this.root.removeWME(null, fact);
        }
        catch (NodeException e) {
            throw new RetractException(e);
        }
    }

    public boolean addRule(Rule rule) throws EvaluationException, RuleException, CompileRuleException {
        boolean result = this.compiler.addRule(rule);
        this.shareNodes(rule);
        return result;
    }

    public void removeRule(Rule rule) {
        this.compiler.removeRule(rule);
    }

    public void clear() {
        this.lastNodeId = 1;
        try {
            this.root.flush();
        }
        catch (NodeException e) {
            this.engine.writeMessage("error while flushing rete network");
        }
    }

    public void addTemplate(Template template) {
        this.compiler.addObjectTypeNode(template);
    }

    public int nextNodeId() {
        return ++this.lastNodeId;
    }

    public RootNode getRoot() {
        return this.root;
    }

    public Engine getEngine() {
        return this.engine;
    }

    private int shareNodes(Rule rule) {
        return 0;
    }

    private int shareAllNodes() {
        int result = 0;
        List<Rule> rules = this.engine.getModules().getAllRules();
        for (Rule rule : rules) {
            result += this.shareNodes(rule);
        }
        return result;
    }

    private void setShareNodes(boolean newValue) {
        boolean oldValue = this.shareNodes;
        this.shareNodes = newValue;
        if (!oldValue && newValue) {
            this.shareAllNodes();
        }
    }

    @Override
    public void settingsChanged(String propertyName) {
        JamochaSettings settings = JamochaSettings.getInstance();
        if (propertyName.equals("engine.net_settings.share_nodes")) {
            this.setShareNodes(settings.getBoolean(propertyName));
        }
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public Set<Node> getAllNodes() {
        Stack<Node> active = new Stack<Node>();
        HashSet<Node> result = new HashSet<Node>();
        active.add(this.root);
        result.add(this.root);
        while (!active.isEmpty()) {
            Node n = (Node)active.pop();
            for (Node child : n.getChildNodes()) {
                active.add(child);
                result.add(child);
            }
        }
        return result;
    }

    public void cleanup() {
        Set<Node> allNodes = this.getAllNodes();
        Stack<Node> usedStack = new Stack<Node>();
        for (Node n : allNodes) {
            if (!(n instanceof TerminalNode)) continue;
            usedStack.push((TerminalNode)n);
        }
        while (!usedStack.isEmpty()) {
            Node n = (Node)usedStack.pop();
            allNodes.remove(n);
            for (Node parent : n.getParentNodes()) {
                usedStack.push(parent);
            }
        }
        for (Node unusedNode : allNodes) {
            unusedNode.unmount();
        }
    }
}

