/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine;

import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.logging.Logging;
import org.jamocha.communication.messagerouter.MessageRouter;
import org.jamocha.communication.messagerouter.StreamChannel;
import org.jamocha.engine.AssertException;
import org.jamocha.engine.Dumpable;
import org.jamocha.engine.ExecuteException;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.RetractException;
import org.jamocha.engine.RuleCompiler;
import org.jamocha.engine.TemporalFactThread;
import org.jamocha.engine.TemporalThread;
import org.jamocha.engine.agenda.Activation;
import org.jamocha.engine.agenda.Agenda;
import org.jamocha.engine.agenda.Agendas;
import org.jamocha.engine.configurations.AssertConfiguration;
import org.jamocha.engine.configurations.ModifyConfiguration;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.configurations.SlotConfiguration;
import org.jamocha.engine.functions.FunctionMemory;
import org.jamocha.engine.functions.FunctionMemoryImpl;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.modules.Modules;
import org.jamocha.engine.rules.rulecompiler.CompileRuleException;
import org.jamocha.engine.scope.BlockingScope;
import org.jamocha.engine.scope.DefaultScope;
import org.jamocha.engine.scope.Scope;
import org.jamocha.engine.util.ProfileStats;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.elements.Deffact;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.InitialFact;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.RuleException;
import org.jamocha.rules.Constraint;
import org.jamocha.rules.LiteralConstraint;
import org.jamocha.rules.ObjectCondition;
import org.jamocha.rules.Rule;
import org.jamocha.settings.JamochaSettings;
import org.jamocha.settings.SettingsChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine
implements Dumpable {
    private static final long serialVersionUID = 1L;
    protected String[] interestedProperties = new String[]{"engine.general_settings.profile_assert", "engine.general_settings.profile_retract"};
    protected ReteNet net = null;
    protected Logging.JamochaLogger log;
    protected FunctionMemory functionMem = null;
    protected Map<String, PrintWriter> outputStreams = new HashMap<String, PrintWriter>();
    protected Scope scopes = new BlockingScope();
    protected Agendas agendas = null;
    protected Modules modules = null;
    protected boolean profileAssert = false;
    protected boolean profileRetract = false;
    protected MessageRouter router = new MessageRouter(this);
    protected InitialFact initFact = new InitialFact();
    protected Map<String, JamochaValue> defglobals;
    protected TemporalFactThread temporalFactThread;
    protected Template triggerFactsTemplate;
    protected int lag;
    protected ModifySynchronizer modifySynchronizer = new ModifySynchronizer();
    protected PrintWriter evalWriter;
    Set<TemporalThread> lags = new HashSet<TemporalThread>();
    int lg;

    public ModifySynchronizer getModifySynchronizer() {
        return this.modifySynchronizer;
    }

    public void eval(String s) {
        this.evalWriter.write(s + "\n");
        this.evalWriter.flush();
    }

    public void eval(String s, Object ... entries) {
        this.eval(String.format(s, entries));
    }

    public Engine() {
        PipedOutputStream outStream = new PipedOutputStream();
        PipedInputStream inStream = new PipedInputStream();
        this.evalWriter = new PrintWriter(outStream);
        try {
            inStream.connect(outStream);
        }
        catch (IOException e) {
            Logging.logger(this.getClass()).fatal(e);
        }
        StreamChannel channel = this.router.openChannel("evalChannel", inStream);
        this.net = new ReteNet(this);
        this.functionMem = new FunctionMemoryImpl(this);
        this.agendas = new Agendas(this);
        this.modules = new Modules(this);
        this.defglobals = new HashMap<String, JamochaValue>();
        this.functionMem.init();
        this.establishInitialFact();
        this.temporalFactThread = new TemporalFactThread(this);
        this.temporalFactThread.registerExceptionListener(new TemporalThreadExceptionHandler());
        this.temporalFactThread.start();
        TemplateSlot[] slots = new TemplateSlot[]{new TemplateSlot("rule-name")};
        slots[0].setValueType(JamochaType.STRING);
        this.triggerFactsTemplate = new Deftemplate("temporal-trigger", null, slots);
        this.findModule("MAIN").addTemplate(this.triggerFactsTemplate);
        JamochaSettings.getInstance().addListener(new EngineSettingsChangedListener(), this.interestedProperties);
        this.log = Logging.logger(this.getClass());
        this.log.info("Jamocha started");
    }

    protected void establishInitialFact() {
        try {
            this.modules.getMainModule().addTemplate(this.initFact);
            Fact ifact = this.initFact.getInitialFact();
            this.modules.addFact(ifact);
            this.assertFact(ifact);
        }
        catch (Exception e) {
            this.log.fatal(e);
        }
    }

    public InitialFact getInitialTemplate() {
        return this.initFact;
    }

    public Fact getInitialFact() {
        return this.initFact.getInitialFact();
    }

    public void clearFacts() {
        this.modules.clearAllFacts();
    }

    public void clearRules() {
        this.modules.clearAllRules();
    }

    public void clearAll() {
        this.clearFacts();
        this.clearRules();
        this.modules.clearAll();
        ProfileStats.reset();
        this.establishInitialFact();
    }

    public void dispose() {
        this.clearAll();
        this.router.dispose();
    }

    public int fire(int count) throws ExecuteException {
        return this.agendas.fireFocus(count);
    }

    public int fire() throws ExecuteException {
        Logging.logger(this.getClass()).debug("Starting firing engine with " + this.getCurrentFocus().getRuleCount() + " rules and " + this.getModules().getAllFacts().size() + " facts and " + this.getAgendas().getAgenda(this.getCurrentFocus()).getActivations().size() + " activations.");
        Logging.logger(this.getClass()).debug("facts are from:");
        for (Fact f : this.getModules().getAllFacts()) {
            Logging.logger(this.getClass()).debug(f.getTemplate().getName() + " (" + f.getClass().getSimpleName() + ")");
        }
        return this.agendas.fireFocus();
    }

    public Module getCurrentFocus() {
        return this.modules.getCurrentModule();
    }

    public Module addModule(String name) {
        Module newMod = this.modules.addModule(name);
        if (newMod == null) {
            return null;
        }
        this.modules.setCurrentModule(newMod);
        return newMod;
    }

    public Module getModule(String name) {
        Module newMod = this.modules.getModule(name);
        this.modules.setCurrentModule(newMod);
        return newMod;
    }

    public Module findModule(String name) {
        return this.modules.findModule(name);
    }

    public Template findTemplate(String name) {
        return this.modules.getCurrentModule().getTemplate(name);
    }

    public void declareDefglobal(String name, JamochaValue value) {
        this.defglobals.put(name, value);
    }

    public JamochaValue getDefglobalValue(String name) {
        return this.defglobals.get(name);
    }

    public Map<String, JamochaValue> getBindings() {
        HashMap<String, JamochaValue> result = new HashMap<String, JamochaValue>();
        for (String defglobalKey : this.defglobals.keySet()) {
            result.put(defglobalKey, this.defglobals.get(defglobalKey));
        }
        for (String scopeKey : this.scopes.getBindings().keySet()) {
            result.put(scopeKey, this.scopes.getBindingValue(scopeKey));
        }
        return result;
    }

    public JamochaValue getBinding(String key) {
        if (key.startsWith("*")) {
            return this.getDefglobalValue(key);
        }
        return this.scopes.getBindingValue(key);
    }

    public void setBinding(String key, JamochaValue value) {
        if (key.startsWith("*")) {
            this.declareDefglobal(key, value);
        } else {
            this.scopes.setBindingValue(key, value);
        }
    }

    public boolean setFocus(String moduleName) {
        return this.modules.setCurrentModule(moduleName);
    }

    public void setWatch(int type) {
        if (type == 2) {
            this.agendas.setWatchActivations(true);
            this.modules.setWatchFact(true);
            this.modules.setWatchRules(true);
        } else if (type == 1) {
            this.agendas.setWatchActivations(true);
        } else if (type == 3) {
            this.modules.setWatchFact(true);
        } else if (type == 4) {
            this.modules.setWatchRules(true);
        }
    }

    public void setUnWatch(int type) {
        if (type == 2) {
            this.agendas.setWatchActivations(false);
            this.modules.setWatchFact(false);
            this.modules.setWatchRules(false);
        } else if (type == 1) {
            this.agendas.setWatchActivations(false);
        } else if (type == 3) {
            this.modules.setWatchFact(false);
        } else if (type == 4) {
            this.modules.setWatchRules(false);
        }
    }

    public void setProfile(int type) {
        if (type == 103) {
            this.agendas.setProfileAddActivation(true);
            this.agendas.setProfileRemoveActivation(true);
            this.agendas.setProfileFire(true);
            this.profileAssert = true;
            this.profileRetract = true;
        } else if (type == 102) {
            this.profileAssert = true;
        } else if (type == 105) {
            this.profileRetract = true;
        } else if (type == 101) {
            this.agendas.setProfileAddActivation(true);
        } else if (type == 106) {
            this.agendas.setProfileRemoveActivation(true);
        } else if (type == 104) {
            this.agendas.setProfileFire(true);
        }
    }

    public void setProfileOff(int type) {
        if (type == 103) {
            this.agendas.setProfileAddActivation(false);
            this.agendas.setProfileRemoveActivation(false);
            this.agendas.setProfileFire(false);
            this.profileAssert = false;
            this.profileRetract = false;
        } else if (type == 102) {
            this.profileAssert = false;
        } else if (type == 105) {
            this.profileRetract = false;
        } else if (type == 101) {
            this.agendas.setProfileAddActivation(false);
        } else if (type == 106) {
            this.agendas.setProfileRemoveActivation(false);
        } else if (type == 104) {
            this.agendas.setProfileFire(false);
        }
    }

    public Fact getFactById(JamochaValue factID) {
        return this.getFactById(factID.getFactIdValue());
    }

    public Fact getFactById(long id) {
        return this.modules.getFactById(id);
    }

    public void addPrintWriter(String name, PrintWriter writer) {
        this.outputStreams.put(name, writer);
    }

    public PrintWriter removePrintWriter(String name) {
        return this.outputStreams.remove(name);
    }

    public void writeMessage(String msg) {
        this.writeMessage(msg, "t");
    }

    public void writeMessage(String msg, String output) {
        MessageRouter router = this.getMessageRouter();
        router.postMessageEvent(new MessageEvent(MessageEvent.MessageEventType.ENGINE, msg, "t".equals(output) ? router.getDefaultChannelId() : output));
        for (PrintWriter wr : this.outputStreams.values()) {
            wr.write(msg);
            wr.flush();
        }
    }

    public void assertFact(Fact o) throws AssertException {
        if (o.getTemporalValidity() != null) {
            this.temporalFactThread.insertFact(o);
        } else {
            this.hardAssertFact(o);
        }
    }

    public void hardAssertFact(Fact o) throws AssertException {
        if (this.profileAssert) {
            ProfileStats.startAssert();
        }
        this.modules.addFact(o);
        this.net.assertFact(o);
        if (this.profileAssert) {
            ProfileStats.endAssert();
        }
    }

    public void retractById(long id) throws RetractException {
        Fact ft = this.modules.getFactById(id);
        this.retractFact(ft);
    }

    public void hardRetractFact(Fact fact) throws RetractException {
        if (this.profileAssert) {
            ProfileStats.startRetract();
        }
        this.modules.removeFact(fact);
        this.net.retractFact(fact);
        if (this.profileAssert) {
            ProfileStats.endRetract();
        }
    }

    public void retractFact(Fact fact) throws RetractException {
        if (fact.getTemporalValidity() == null) {
            this.hardRetractFact(fact);
        } else {
            this.temporalFactThread.removeFact(fact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyFact(Fact old, ModifyConfiguration mc) throws EvaluationException {
        ModifySynchronizer modifySynchronizer = this.modifySynchronizer;
        synchronized (modifySynchronizer) {
            boolean allSilent = true;
            for (SlotConfiguration slot : mc.getSlots()) {
                allSilent &= old.isSlotSilent(slot.getId());
            }
            if (allSilent) {
                old.updateSlots(this, mc.getSlots());
            } else {
                Fact modifiedFact = old instanceof Deffact ? ((Deffact)old).cloneFact(this) : old;
                modifiedFact.setFactId(old.getFactId());
                this.hardRetractFact(old);
                modifiedFact.updateSlots(this, mc.getSlots());
                this.hardAssertFact(modifiedFact);
                String msg = "modified a " + old.getTemplate().getName() + ":";
                for (SlotConfiguration sc : mc.getSlots()) {
                    msg = msg + sc.getSlotName() + "=" + sc.getValue(this) + ";";
                }
                Logging.logger(this.getClass()).debug(msg);
            }
        }
    }

    public void resetFacts() {
        try {
            List<Fact> facts = this.modules.getAllFacts();
            for (Fact ft : facts) {
                this.net.retractFact(ft);
            }
            for (Fact ft : facts) {
                this.net.assertFact(ft);
            }
        }
        catch (RetractException e) {
            this.log.warn(e);
        }
        catch (AssertException e) {
            this.log.warn(e);
        }
    }

    public Modules getModules() {
        return this.modules;
    }

    public Agendas getAgendas() {
        return this.agendas;
    }

    public FunctionMemory getFunctionMemory() {
        return this.functionMem;
    }

    public MessageRouter getMessageRouter() {
        return this.router;
    }

    public void pushScope() {
        this.pushScope(new DefaultScope());
    }

    public void popScope() {
        if (this.scopes.getOuterScope() != null) {
            this.scopes = this.scopes.popScope();
        }
    }

    public void pushScope(Scope scope) {
        scope.pushScope(this.scopes);
        this.scopes = scope;
    }

    public boolean addTemplate(Template tpl) throws EvaluationException {
        tpl.evaluateStaticDefaults(this);
        Module mod = tpl.checkUserDefinedModuleName(this);
        if (mod == null) {
            mod = this.getCurrentFocus();
        }
        boolean result = mod.addTemplate(tpl);
        return result;
    }

    public void removeRule(Rule rule) {
        this.net.removeRule(rule);
        rule.parentModule().removeRule(rule);
        Agenda a = this.agendas.getAgenda(rule.parentModule());
        Iterator<Activation> it = a.getActivations().iterator();
        while (it.hasNext()) {
            Activation act = it.next();
            if (act.getRule() != rule) continue;
            it.remove();
        }
    }

    public boolean addRule(Rule rule) throws EvaluationException, RuleException, CompileRuleException {
        boolean result = false;
        if (rule.getTemporalValidity() != null) {
            AssertConfiguration triggerConf = new AssertConfiguration();
            triggerConf.setTemplateName("temporal-trigger");
            Parameter[] data = new Parameter[1];
            JamochaValue rulename = JamochaValue.newString(rule.parentModule().getName() + ":" + rule.getName());
            Signature slot1 = new Signature("rule-name");
            Parameter[] params = new Parameter[1];
            slot1.setParameters(params);
            data[0] = slot1;
            params[0] = rulename;
            triggerConf.setData(data);
            triggerConf.setTemporalValidity(rule.getTemporalValidity());
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            LiteralConstraint lc = new LiteralConstraint(rulename, "rule-name");
            constraints.add(lc);
            ObjectCondition triggerCondition = new ObjectCondition(constraints, "temporal-trigger");
            rule.getConditions().add(triggerCondition);
            Fact trigger = this.getModules().createFact(triggerConf);
            this.assertFact(trigger);
        }
        if (!this.getCurrentFocus().containsRule(rule)) {
            result = this.net.addRule(rule);
        }
        return result;
    }

    public ReteNet getNet() {
        return this.net;
    }

    public static String[] getJamochaSearchPaths() {
        String path = System.getenv("JAMOCHA_PATH");
        if (path != null && path.length() > 0) {
            return path.split(System.getProperty("path.separator"));
        }
        return null;
    }

    public WorkingMemory getWorkingMemory() {
        return this.net.getWorkingMemory();
    }

    @Override
    public String getDump() {
        StringBuilder sb = new StringBuilder();
        for (Module m : this.getModules().getModuleList()) {
            sb.append("\n%dump module ").append(m.getName()).append("\n");
            sb.append(m.getDump());
        }
        for (Fact f : this.getModules().getAllFacts()) {
            sb.append(f.getDump()).append("\n");
        }
        return sb.toString();
    }

    public void pushScope(Rule rule) {
    }

    public RuleCompiler getRuleCompiler() {
        return this.net.compiler;
    }

    public int getLag() {
        return this.temporalFactThread.getLag();
    }

    private class TemporalThreadExceptionHandler
    implements ExceptionListener {
        private TemporalThreadExceptionHandler() {
        }

        public void exceptionThrown(Exception e) {
            Engine.this.log.fatal(e);
        }
    }

    private class EngineSettingsChangedListener
    implements SettingsChangedListener {
        private EngineSettingsChangedListener() {
        }

        public void settingsChanged(String propertyName) {
            JamochaSettings settings = JamochaSettings.getInstance();
            if (propertyName.equals("engine.general_settings.profile_assert")) {
                Engine.this.profileAssert = settings.getBoolean(propertyName);
            } else if (propertyName.equals("engine.general_settings.profile_retract")) {
                Engine.this.profileRetract = settings.getBoolean(propertyName);
            }
        }
    }

    private class ModifySynchronizer {
        private ModifySynchronizer() {
        }
    }
}

