/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.messagerouter;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.messagerouter.AbstractCommunicationChannel;
import org.jamocha.communication.messagerouter.InterestType;
import org.jamocha.communication.messagerouter.MessageRouter;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.languages.clips.parser.TokenMgrError;
import org.jamocha.parser.Expression;
import org.jamocha.parser.ParseException;
import org.jamocha.parser.ParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringChannelImpl
extends AbstractCommunicationChannel
implements StringChannel {
    private final List<MessageEvent> alreadyReceived = new LinkedList<MessageEvent>();

    public StringChannelImpl(String channelId, MessageRouter router, InterestType interest) {
        super(channelId, router, interest);
        this.parser = ParserFactory.getParser((Reader)null);
    }

    @Override
    public void executeCommand(String commandString) {
        this.executeCommand(commandString, false);
    }

    @Override
    public void executeCommand(String commandString, boolean blocked) {
        StringReader reader = new StringReader(commandString);
        LinkedList<MessageEvent> commandMessages = blocked ? new LinkedList<MessageEvent>() : null;
        this.restartParser(reader);
        Expression command = null;
        try {
            this.alreadyReceived.clear();
            while ((command = this.parser.nextExpression()) != null) {
                this.router.enqueueCommand(command, this.getChannelId());
                if (!blocked) continue;
                try {
                    while (blocked) {
                        MessageEvent lastMessage;
                        this.router.fillMessageList(this.getChannelId(), commandMessages);
                        int count = commandMessages.size();
                        if (count > 0 && ((lastMessage = (MessageEvent)commandMessages.get(count - 1)).getType() == MessageEvent.MessageEventType.RESULT || lastMessage.getType() == MessageEvent.MessageEventType.ERROR)) {
                            this.alreadyReceived.addAll(commandMessages);
                            commandMessages.clear();
                            blocked = false;
                        }
                        if (!blocked) continue;
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                blocked = true;
            }
        }
        catch (ParseException e) {
            this.router.postMessageEvent(new MessageEvent(MessageEvent.MessageEventType.PARSE_ERROR, e, this.getChannelId()));
            this.restartParser(reader);
        }
        catch (TokenMgrError e) {
            this.router.postMessageEvent(new MessageEvent(MessageEvent.MessageEventType.PARSE_ERROR, e, this.getChannelId()));
            this.restartParser(reader);
        }
    }

    @Override
    public void fillEventList(List<MessageEvent> eventList) {
        eventList.addAll(this.alreadyReceived);
        super.fillEventList(eventList);
    }
}

