/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.messagerouter;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.messagerouter.AbstractCommunicationChannel;
import org.jamocha.communication.messagerouter.InterestType;
import org.jamocha.communication.messagerouter.MessageRouter;
import org.jamocha.communication.messagerouter.StreamChannel;
import org.jamocha.parser.Expression;
import org.jamocha.parser.ParseException;
import org.jamocha.parser.ParserFactory;

class StreamChannelImpl
extends AbstractCommunicationChannel
implements StreamChannel {
    private Reader reader;
    private StreamChannelThread streamChannelThread = new StreamChannelThread();
    private boolean initDone = false;

    public StreamChannelImpl(String channelId, MessageRouter router, InterestType interest) {
        super(channelId, router, interest);
    }

    public void init(InputStream inputStream) {
        this.init(new InputStreamReader(inputStream));
    }

    public void init(Reader reader) {
        this.reader = reader;
        this.streamChannelThread.setStopped();
        this.streamChannelThread = new StreamChannelThread();
        this.parser = ParserFactory.getParser(reader);
        this.streamChannelThread.start();
        this.initDone = true;
    }

    void close() {
        this.streamChannelThread.setStopped();
    }

    public boolean isAvailable() {
        return this.initDone;
    }

    private class StreamChannelThread
    extends Thread {
        private boolean stopped = false;

        private StreamChannelThread() {
        }

        public void run() {
            while (!this.stopped) {
                Expression command = null;
                try {
                    while (!this.stopped && StreamChannelImpl.this.parser != null && (command = StreamChannelImpl.this.parser.nextExpression()) != null) {
                        StreamChannelImpl.this.router.enqueueCommand(command, StreamChannelImpl.this.getChannelId());
                    }
                }
                catch (ParseException e) {
                    StreamChannelImpl.this.router.postMessageEvent(new MessageEvent(MessageEvent.MessageEventType.PARSE_ERROR, e, StreamChannelImpl.this.getChannelId()));
                    StreamChannelImpl.this.restartParser(StreamChannelImpl.this.reader);
                }
                catch (NullPointerException e) {
                    if (this.stopped) continue;
                    throw e;
                }
            }
        }

        private void setStopped() {
            this.stopped = true;
        }
    }
}

