/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.jsr94;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rules.Handle;
import javax.rules.InvalidHandleException;
import javax.rules.InvalidRuleSessionException;
import javax.rules.ObjectFilter;
import javax.rules.RuleExecutionSetMetadata;
import javax.rules.StatefulRuleSession;
import javax.rules.admin.RuleExecutionSet;
import org.jamocha.communication.jsr94.JamochaFactHandle;
import org.jamocha.communication.jsr94.JamochaRuleExecutionSet;
import org.jamocha.communication.jsr94.JamochaRuleExecutionSetMetadata;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.AssertException;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ExecuteException;
import org.jamocha.engine.RetractException;
import org.jamocha.engine.workingmemory.elements.Deffact;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.JavaFact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.Expression;
import org.jamocha.parser.RuleException;

public class JamochaStatefulRuleSession
implements StatefulRuleSession {
    private final RuleExecutionSet res;
    private final String uri;
    private Engine engine = new Engine();
    protected Map properties;

    public JamochaStatefulRuleSession(JamochaRuleExecutionSet res, String uri, Map properties) {
        this.res = res;
        this.uri = uri;
        this.properties = properties != null ? properties : new HashMap();
        try {
            this.addRules(res);
        }
        catch (EvaluationException e) {
            e.printStackTrace();
        }
    }

    protected void addRules(JamochaRuleExecutionSet res2) throws EvaluationException, RuleException {
        Expression[] exprs;
        for (Expression e : exprs = res2.getExpressions()) {
            e.getValue(this.getEngine());
        }
    }

    public RuleExecutionSetMetadata getRuleExecutionSetMetadata() throws InvalidRuleSessionException, RemoteException {
        return new JamochaRuleExecutionSetMetadata(this.res, this.uri);
    }

    public int getType() throws RemoteException, InvalidRuleSessionException {
        return 0;
    }

    public void release() throws RemoteException, InvalidRuleSessionException {
        this.engine.dispose();
    }

    public Handle addObject(Object o) throws RemoteException, InvalidRuleSessionException {
        return this.addObject(o, -1L);
    }

    protected Handle addObject(Object o, long id) throws RemoteException, InvalidRuleSessionException {
        try {
            if (o instanceof Fact) {
                Fact f = (Fact)o;
                if (id > 0L) {
                    f.setFactId(id);
                }
                this.engine.assertFact(f);
                return new JamochaFactHandle(f.getFactId());
            }
            JavaFact f = new JavaFact(o, this.getEngine());
            if (id > 0L) {
                f.setFactId(id);
            }
            this.engine.assertFact(f);
            return new JamochaFactHandle(f.getFactId());
        }
        catch (AssertException e) {
            throw new InvalidRuleSessionException("error while adding object", (Exception)e);
        }
    }

    public List addObjects(List arg0) throws RemoteException, InvalidRuleSessionException {
        ArrayList<Handle> result = new ArrayList<Handle>();
        for (Object o : arg0) {
            result.add(this.addObject(o));
        }
        return result;
    }

    public boolean containsObject(Handle arg0) throws RemoteException, InvalidRuleSessionException, InvalidHandleException {
        return this.getEngine().getFactById(((JamochaFactHandle)arg0).getId()) != null;
    }

    public void executeRules() throws RemoteException, InvalidRuleSessionException {
        try {
            this.getEngine().fire();
        }
        catch (ExecuteException e) {
            throw new InvalidRuleSessionException("error while firing engine", (Exception)e);
        }
    }

    public List getHandles() throws RemoteException, InvalidRuleSessionException {
        ArrayList<JamochaFactHandle> result = new ArrayList<JamochaFactHandle>();
        for (Fact f : this.engine.getModules().getAllFacts()) {
            if (f instanceof Deffact) continue;
            result.add(new JamochaFactHandle(f.getFactId()));
        }
        return result;
    }

    public Object getObject(Handle arg0) throws RemoteException, InvalidHandleException, InvalidRuleSessionException {
        Fact f = this.engine.getFactById(((JamochaFactHandle)arg0).getId());
        if (f instanceof Deffact) {
            return f;
        }
        if (f instanceof JavaFact) {
            JavaFact jaf = (JavaFact)f;
            return jaf.getObject();
        }
        throw new InvalidHandleException("no known type of fact");
    }

    public List getObjects() throws RemoteException, InvalidRuleSessionException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object h : this.getHandles()) {
            JamochaFactHandle fh = (JamochaFactHandle)h;
            try {
                if (this.getObject(fh) instanceof Deffact) continue;
                result.add(this.getObject(fh));
            }
            catch (InvalidHandleException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List getObjects(ObjectFilter arg0) throws RemoteException, InvalidRuleSessionException {
        ArrayList<Object> result = new ArrayList<Object>();
        List all = this.getObjects();
        for (Object o : all) {
            Object r = arg0.filter(o);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    public void removeObject(Handle arg0) throws RemoteException, InvalidHandleException, InvalidRuleSessionException {
        try {
            this.engine.retractById(((JamochaFactHandle)arg0).getId());
        }
        catch (RetractException e) {
            throw new InvalidHandleException("error while retracting", (Exception)e);
        }
    }

    public void reset() throws RemoteException, InvalidRuleSessionException {
        for (Fact f : this.getEngine().getModules().getAllFacts()) {
            if (f.getTemplate().getName().equals("_initialFact")) continue;
            try {
                this.getEngine().retractFact(f);
            }
            catch (RetractException e) {
                Logging.logger(this.getClass()).warn("Error while resetting session. Cannot retract fact " + f);
            }
        }
    }

    public void updateObject(Handle arg0, Object arg1) throws RemoteException, InvalidRuleSessionException, InvalidHandleException {
        long id = ((JamochaFactHandle)arg0).getId();
        this.removeObject(arg0);
        this.addObject(arg1, id);
    }

    protected Engine getEngine() {
        return this.engine;
    }
}

