/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.jsr94;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.rules.admin.RuleExecutionSetProvider;
import org.jamocha.communication.jsr94.JamochaLocalRuleExecutionSetProvider;
import org.jamocha.communication.jsr94.JamochaRuleExecutionSet;
import org.jamocha.languages.clips.parser.SFPParser;
import org.jamocha.parser.Expression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JamochaRuleExecutionSetProvider
implements RuleExecutionSetProvider {
    public RuleExecutionSet createRuleExecutionSet(Reader r, Map properties) throws RuleExecutionSetCreateException, IOException {
        try {
            Expression e;
            DOMParser domparser = new DOMParser();
            domparser.parse(new InputSource(r));
            Document doc = domparser.getDocument();
            Element root = doc.getDocumentElement();
            String name = root.getElementsByTagName("name").item(0).getTextContent();
            String description = root.getElementsByTagName("description").item(0).getTextContent();
            String code = root.getElementsByTagName("code").item(0).getTextContent();
            SFPParser sfpparser = new SFPParser(new StringReader(code));
            ArrayList<Expression> _drcs = new ArrayList<Expression>();
            while ((e = sfpparser.nextExpression()) != null) {
                _drcs.add(e);
            }
            Expression[] expressions = new Expression[_drcs.size()];
            expressions = _drcs.toArray(expressions);
            JamochaRuleExecutionSet res = new JamochaRuleExecutionSet(description, name, expressions);
            return res;
        }
        catch (Exception ex) {
            throw new RuleExecutionSetCreateException("error while parsing or creating rule set", ex);
        }
    }

    public RuleExecutionSet createRuleExecutionSet(InputStream i, Map properties) throws RuleExecutionSetCreateException, IOException {
        InputStreamReader r = new InputStreamReader(i);
        return this.createRuleExecutionSet(r, properties);
    }

    public RuleExecutionSet createRuleExecutionSet(Serializable object, Map properties) throws RuleExecutionSetCreateException {
        return null;
    }

    public RuleExecutionSet createRuleExecutionSet(Element root, Map properties) throws RuleExecutionSetCreateException, RemoteException {
        try {
            return JamochaLocalRuleExecutionSetProvider.createRuleExecutionSetFromXML(root, properties);
        }
        catch (IOException e) {
            throw new RuleExecutionSetCreateException("error while reading", (Exception)e);
        }
    }

    public RuleExecutionSet createRuleExecutionSet(String url, Map properties) throws RuleExecutionSetCreateException, IOException, RemoteException {
        URL sourceUrl = new URL(url);
        FileReader r = null;
        if (!sourceUrl.getProtocol().equals("file")) {
            throw new RuleExecutionSetCreateException(sourceUrl.getProtocol() + " protocol is not supported");
        }
        r = new FileReader(new File(sourceUrl.getFile()));
        return JamochaLocalRuleExecutionSetProvider.createRuleExecutionSetAutoprobe(r, properties);
    }
}

