/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.jsr94;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import org.jamocha.communication.jsr94.JamochaRuleExecutionSet;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.languages.clips.parser.ParseException;
import org.jamocha.languages.clips.parser.SFPParser;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.Expression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JamochaLocalRuleExecutionSetProvider
implements LocalRuleExecutionSetProvider {
    static RuleExecutionSet createRuleExecutionSetAutoprobe(Reader r, Map properties) throws IOException, RuleExecutionSetCreateException {
        int read;
        RuleExecutionSet res = null;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1000];
        while ((read = r.read(buffer, 0, buffer.length)) > 0) {
            sb.append(buffer, 0, read);
        }
        String content = sb.toString().trim();
        if (content.startsWith("<?xml ")) {
            DOMParser domparser = new DOMParser();
            try {
                domparser.parse(new InputSource(new StringReader(content)));
            }
            catch (SAXException e) {
                throw new RuleExecutionSetCreateException("error while parsing");
            }
            Document doc = domparser.getDocument();
            Element root = doc.getDocumentElement();
            res = JamochaLocalRuleExecutionSetProvider.createRuleExecutionSetFromXML(root, properties);
        } else {
            res = JamochaLocalRuleExecutionSetProvider.createRuleExecutionSetFromCLIPS(content, properties, null, null, true);
        }
        return res;
    }

    static RuleExecutionSet createRuleExecutionSetFromCLIPS(String code, Map properties, String name, String description, boolean parseForNameAndDesc) throws RuleExecutionSetCreateException {
        SFPParser sfpparser = new SFPParser(new StringReader(code));
        ArrayList<Expression> _drcs = new ArrayList<Expression>();
        try {
            Expression e;
            while ((e = sfpparser.nextExpression()) != null) {
                _drcs.add(e);
                if (!parseForNameAndDesc || !(e instanceof Signature)) continue;
                Signature s = (Signature)e;
                if (s.getSignatureName().equals("jsr94-ruleset-description")) {
                    try {
                        name = s.getParameters()[0].getValue(null).getStringValue();
                    }
                    catch (EvaluationException e1) {
                        Logging.logger(RuleExecutionSet.class).warn("error retrieving rule execution set's name");
                    }
                } else if (s.getSignatureName().equals("jsr94-ruleset-name")) {
                    try {
                        description = s.getParameters()[0].getValue(null).getStringValue();
                    }
                    catch (EvaluationException e1) {
                        Logging.logger(RuleExecutionSet.class).warn("error retrieving rule execution set's description");
                    }
                }
                if (name == null || description == null) continue;
                parseForNameAndDesc = false;
            }
        }
        catch (ParseException e1) {
            throw new RuleExecutionSetCreateException("error while parsing", (Exception)e1);
        }
        Expression[] expressions = new Expression[_drcs.size()];
        expressions = _drcs.toArray(expressions);
        if (description == null) {
            description = "";
        }
        if (name == null) {
            name = "ruleset-" + (int)(10000.0 * Math.random());
        }
        JamochaRuleExecutionSet res = new JamochaRuleExecutionSet(description, name, expressions);
        return res;
    }

    static RuleExecutionSet createRuleExecutionSetFromXML(Element root, Map properties) throws RuleExecutionSetCreateException, IOException {
        try {
            String name = root.getElementsByTagName("name").item(0).getChildNodes().item(0).getNodeValue();
            String description = root.getElementsByTagName("description").item(0).getChildNodes().item(0).getNodeValue();
            String code = root.getElementsByTagName("code").item(0).getChildNodes().item(0).getNodeValue();
            RuleExecutionSet res = JamochaLocalRuleExecutionSetProvider.createRuleExecutionSetFromCLIPS(code, properties, name, description, false);
            return res;
        }
        catch (Exception ex) {
            throw new RuleExecutionSetCreateException("error while parsing or creating rule set", ex);
        }
    }

    public RuleExecutionSet createRuleExecutionSet(InputStream i, Map properties) throws RuleExecutionSetCreateException, IOException {
        InputStreamReader r = new InputStreamReader(i);
        return this.createRuleExecutionSet(r, properties);
    }

    public RuleExecutionSet createRuleExecutionSet(Object object, Map properties) throws RuleExecutionSetCreateException {
        return null;
    }

    public RuleExecutionSet createRuleExecutionSet(Reader r, Map properties) throws RuleExecutionSetCreateException, IOException {
        return JamochaLocalRuleExecutionSetProvider.createRuleExecutionSetAutoprobe(r, properties);
    }
}

