/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication.agent;

import jade.core.AID;
import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import java.util.Date;
import org.jamocha.communication.agent.JamochaAgent;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.parser.ParserUtils;

public class MessageReceiver
extends CyclicBehaviour {
    private static final long serialVersionUID = 1L;
    private JamochaAgent agent;
    private StringChannel channel;

    public MessageReceiver(JamochaAgent agent) {
        this.agent = agent;
        this.channel = agent.getEngine().getMessageRouter().openChannel(agent.getProperties().getProperty("agent.name", "Agent"));
    }

    public void action() {
        ACLMessage msg = this.agent.receive();
        if (msg != null) {
            String assertion = this.createAssertString(msg);
            if (this.agent.getProperties().getBooleanProperty("agent.autofire", true)) {
                assertion = assertion + "(fire)";
            }
            this.channel.executeCommand(assertion);
        } else {
            this.block(100L);
        }
    }

    private String createAssertString(ACLMessage msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("(assert (").append("agent-message");
        sb.append("(sender (assert (agent-identifier (name \"");
        sb.append(msg.getSender().getName()).append("\"))))");
        sb.append("(receiver ");
        Iterator itReceiver = msg.getAllReceiver();
        while (itReceiver.hasNext()) {
            sb.append("(assert (agent-identifier (name \"");
            sb.append(((AID)itReceiver.next()).getName());
            sb.append("\"))) ");
        }
        sb.append(")");
        sb.append("(reply-to ");
        Iterator itReplyTo = msg.getAllReplyTo();
        while (itReplyTo.hasNext()) {
            sb.append("(assert (agent-identifier (name \"");
            sb.append(((AID)itReplyTo.next()).getName());
            sb.append("\"))) ");
        }
        sb.append(")");
        sb.append("(performative \"").append(ACLMessage.getPerformative((int)msg.getPerformative()).toLowerCase()).append("\")");
        if (msg.getContent() != null) {
            sb.append("(content \"").append(ParserUtils.escapeStringLiteral(msg.getContent())).append("\")");
        } else {
            sb.append("(content \"").append("\")");
        }
        if (msg.getLanguage() != null) {
            sb.append("(language \"").append(msg.getLanguage()).append("\")");
        } else {
            sb.append("(language \"").append("\")");
        }
        if (msg.getEncoding() != null) {
            sb.append("(encoding \"").append(msg.getEncoding()).append("\")");
        } else {
            sb.append("(encoding \"").append("\")");
        }
        if (msg.getOntology() != null) {
            sb.append("(ontology \"").append(msg.getOntology()).append("\")");
        } else {
            sb.append("(ontology \"").append("\")");
        }
        if (msg.getProtocol() != null) {
            sb.append("(protocol \"").append(msg.getProtocol().toLowerCase()).append("\")");
        } else {
            sb.append("(protocol \"").append("\")");
        }
        if (msg.getConversationId() != null) {
            sb.append("(conversation-id \"").append(msg.getConversationId()).append("\")");
        } else {
            sb.append("(conversation-id \"").append("\")");
        }
        if (msg.getInReplyTo() != null) {
            sb.append("(in-reply-to \"").append(msg.getInReplyTo()).append("\")");
        } else {
            sb.append("(in-reply-to \"").append("\")");
        }
        if (msg.getReplyWith() != null) {
            sb.append("(reply-with \"").append(msg.getReplyWith()).append("\")");
        } else {
            sb.append("(reply-with \"").append("\")");
        }
        Date replyBy = msg.getReplyByDate();
        if (replyBy == null) {
            sb.append("(reply-by 0)");
        } else {
            sb.append("(reply-by ").append(ParserUtils.dateToLong(replyBy)).append(")");
        }
        sb.append("(timestamp ").append(System.currentTimeMillis()).append(")");
        sb.append("(incoming TRUE)");
        sb.append("))");
        return sb.toString();
    }
}

